/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.categories.options;

import de.vandermeer.skb.base.Skb_ToStringStyle;
import de.vandermeer.skb.categories.HasDescription;
import de.vandermeer.skb.categories.kvt.IsKey;
import de.vandermeer.skb.categories.kvt.IsValue;
import de.vandermeer.skb.categories.kvt.KeyValueType;
import de.vandermeer.skb.categories.options.OptionType;

public interface Option<V>
extends HasDescription,
KeyValueType<String, V, String> {
    default public String toLog(Class<?> clazz) {
        return Skb_ToStringStyle.kv(clazz, (Object[])new Object[]{this.getKey()._value(), this.getValue()._value(), this.getDescription()}).toString();
    }

    public static <V> Option<V> create(final IsKey<String> key, final IsValue<V> value, final OptionType type, final String description) {
        return new Option<V>(){

            @Override
            public IsKey<String> getKey() {
                return key;
            }

            public OptionType getValueType() {
                return type;
            }

            @Override
            public IsValue<V> getValue() {
                return value;
            }

            public String toString() {
                return this.toLog(Option.class);
            }

            @Override
            public Object getDescription() {
                return description == null ? "##default description##" : description;
            }
        };
    }

    public static <V> Option<V> create(String key, V value, String description) {
        OptionType type = null;
        if (value.getClass().equals(Boolean.class)) {
            type = OptionType.BOOLEAN;
        } else if (value.getClass().equals(Character.class)) {
            type = OptionType.CHARACHTER;
        } else if (value.getClass().equals(String.class)) {
            type = OptionType.STRING;
        } else if (value.getClass().equals(Double.class)) {
            type = OptionType.DOUBLE;
        } else if (value.getClass().equals(Integer.class)) {
            type = OptionType.INTEGER;
        } else if (new char[0].getClass().isAssignableFrom(value.getClass())) {
            type = OptionType.CHARACTER_ARRAY;
        } else {
            throw new RuntimeException("unknown type for option");
        }
        return Option.create(IsKey.create(key), IsValue.create(value), type, description);
    }

    public static <V> Option<V> create(String key, V value) {
        return Option.create(key, value, null);
    }
}

