/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.categories;

import de.vandermeer.skb.base.Skb_Transformer;
import de.vandermeer.skb.base.utils.Skb_TextUtils;
import de.vandermeer.skb.categories.CategoryIs;
import de.vandermeer.skb.categories.CategoryWithValue;
import de.vandermeer.skb.categories.HasDescription;
import de.vandermeer.skb.collections.CollectionFilters;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.antlr.v4.runtime.misc.Pair;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public interface IsPath
extends CategoryIs,
CategoryWithValue,
HasDescription {
    default public String path() {
        return this._value();
    }

    @Override
    public String _value();

    public static IsPath create(final Object path, final String description) {
        if (path != null && path instanceof IsPath) {
            return (IsPath)path;
        }
        return new IsPath(){

            @Override
            public String _value() {
                return path == null ? "##default value##" : path.toString();
            }

            @Override
            public Object getDescription() {
                return description == null ? "##default description##" : description;
            }

            public String toString() {
                return this.toLog(IsPath.class);
            }
        };
    }

    public static IsPath create(Object path) {
        return IsPath.create(path, null);
    }

    public static IsPath create() {
        return IsPath.create(null);
    }

    public static Predicate<Object> IS_VALID_PATH_VALUE(final String separator) {
        return new Predicate<Object>(){

            @Override
            public boolean test(Object fqpn) {
                String path = null;
                try {
                    path = fqpn instanceof IsPath ? ((IsPath)fqpn).path().toString() : fqpn.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (path == null) {
                    return false;
                }
                if (path.isEmpty()) {
                    return false;
                }
                if (path.length() == 1 && path.startsWith(separator)) {
                    return true;
                }
                return path.startsWith(separator) && !path.contains(separator + separator) && !path.endsWith(separator);
            }
        };
    }

    public static Predicate<String> IS_SUB_PATH_OF(final String separator, final Object fqpn) {
        return new Predicate<String>(){
            Skb_Transformer<Object, Integer> transformer;
            {
                this.transformer = IsPath.PATH_TO_LEVELS(separator);
            }

            @Override
            public boolean test(String s) {
                int curLevel;
                String path = null;
                try {
                    path = fqpn instanceof IsPath ? ((IsPath)fqpn).path().toString() : fqpn.toString();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (path == null) {
                    return false;
                }
                int level = (Integer)this.transformer.transform(fqpn);
                if (s.equals(path)) {
                    return false;
                }
                return s.startsWith(path) && level <= (curLevel = ((Integer)this.transformer.transform((Object)s)).intValue());
            }
        };
    }

    public static Skb_Transformer<Object, Integer> PATH_TO_LEVELS(final String separator) {
        return new Skb_Transformer<Object, Integer>(){
            private final Predicate<Object> isValidPath;
            {
                this.isValidPath = IsPath.IS_VALID_PATH_VALUE(separator);
            }

            public Integer transform(Object fqpn) {
                Integer ret = -1;
                String path = null;
                try {
                    path = fqpn instanceof IsPath ? ((IsPath)fqpn).path().toString() : fqpn.toString();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (this.isValidPath.test(fqpn)) {
                    ret = path.length() == 1 && path.startsWith(separator) ? Integer.valueOf(0) : Integer.valueOf(StringUtils.countMatches((CharSequence)path, (CharSequence)separator));
                }
                return ret;
            }
        };
    }

    public static Collection<String> GET_SUB_PATHS(String separator, Object fqpn, Collection<String> coll) {
        return new CollectionFilters<String>(){}.filter(IsPath.IS_SUB_PATH_OF(separator, fqpn), coll);
    }

    public static Skb_Transformer<StrBuilder, List<String>> PATH_TO_ARRAY_OF_PATHS(final String separator, final Boolean autoRootArray) {
        return new Skb_Transformer<StrBuilder, List<String>>(){
            private final Predicate<Object> isValidPath;
            {
                this.isValidPath = IsPath.IS_VALID_PATH_VALUE(separator);
            }

            public List<String> transform(StrBuilder fqpn) {
                LinkedList<String> ret = new LinkedList<String>();
                if (this.isValidPath.test(fqpn)) {
                    if (autoRootArray.booleanValue()) {
                        ret.add(separator);
                    }
                    String[] elements = StringUtils.split((String)fqpn.toString(), (String)separator);
                    StrBuilder add = new StrBuilder(25);
                    for (int i = 0; i < elements.length; ++i) {
                        add.clear();
                        for (int k = 0; k <= i; ++k) {
                            add.append(separator).append(elements[k]);
                        }
                        ret.add(add.toString());
                    }
                }
                return ret;
            }
        };
    }

    public static Skb_Transformer<StrBuilder, StrBuilder> CLEAN_PATH(final String separator) {
        return new Skb_Transformer<StrBuilder, StrBuilder>(){

            public StrBuilder transform(StrBuilder in) {
                try {
                    if (in.size() > 0) {
                        Object[] ar = StringUtils.split((String)in.toString(), (String)separator);
                        in.clear();
                        in.appendWithSeparators(ar, separator);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return in;
            }
        };
    }

    public static Skb_Transformer<StrBuilder, StrBuilder> ADD_ROOT(final String separator) {
        return new Skb_Transformer<StrBuilder, StrBuilder>(){

            public StrBuilder transform(StrBuilder fqpn) {
                try {
                    if (fqpn.indexOf(separator) != 0) {
                        fqpn.insert(0, separator);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return fqpn;
            }
        };
    }

    public static <A, B> Skb_Transformer<Pair<A, B>, StrBuilder> JOIN_PATH_ELEMENTS(final String separator, final Boolean doClean, final Boolean setRoot) {
        return new Skb_Transformer<Pair<A, B>, StrBuilder>(){
            Skb_Transformer<Object, StrBuilder> tr;
            Skb_Transformer<StrBuilder, StrBuilder> clean;
            Skb_Transformer<StrBuilder, StrBuilder> asRoot;
            {
                this.tr = Skb_TextUtils.MANYOBJECTS_TO_STRBUILDER((Object)separator, (Skb_Transformer)Skb_Transformer.CHAIN((Skb_Transformer[])new Skb_Transformer[]{CategoryWithValue.CAT_TO_VALUESTRING(), Skb_TextUtils.TO_STRING()}));
                this.clean = IsPath.CLEAN_PATH(separator);
                this.asRoot = IsPath.ADD_ROOT(separator);
            }

            public StrBuilder transform(Pair<A, B> pair) {
                StrBuilder ret = new StrBuilder(20);
                if (pair.a == null && pair.b == null) {
                    return ret;
                }
                ret = (StrBuilder)this.tr.transform(pair.a);
                if (!ret.endsWith(separator)) {
                    ret.append(separator);
                }
                ret.append((StrBuilder)this.tr.transform(pair.b));
                if (doClean.booleanValue()) {
                    ret = (StrBuilder)this.clean.transform((Object)ret);
                }
                if (setRoot.booleanValue()) {
                    ret = (StrBuilder)this.asRoot.transform((Object)ret);
                }
                return ret;
            }
        };
    }

    public static StrBuilder forMaxDepth(StrBuilder fqpn, int maxDepth, String separator) {
        Skb_Transformer<Object, Integer> transformer = IsPath.PATH_TO_LEVELS(separator);
        if (maxDepth == -1 || (Integer)transformer.transform((Object)fqpn) <= maxDepth) {
            return fqpn;
        }
        return new StrBuilder();
    }
}

