/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.service.scanner;

import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.scanner.AvsScannerEnine;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.service.scanner.ClamNetworkScannerConfig;
import de.valtech.avs.core.service.scanner.ClamScannerEngine;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AvsScannerEnine.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=ClamNetworkScannerConfig.class)
public class ClamNetworkScannerEngine
implements AvsScannerEnine {
    private static final String INSTREAM_SIZE_LIMIT_EXCEEDED_ERROR = "INSTREAM size limit exceeded. ERROR";
    private static final int CHUNK_SIZE_FIELD_LENGTH = 4;
    private static final Logger LOG = LoggerFactory.getLogger(ClamScannerEngine.class);
    private static final int DEFAULT_CHUNK_SIZE = 0x100000;
    private static final int DEFAULT_TIMEOUT = 5;
    private ClamNetworkScannerConfig config;

    @Activate
    public void activate(ClamNetworkScannerConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScanResult scan(InputStream content, String fileName) throws AvsException {
        try (Socket socket = this.connect();
             BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
             InputStream in = socket.getInputStream();){
            socket.setSoTimeout(this.getConnectionTimeout() * 1000);
            ((OutputStream)out).write("nINSTREAM\n".getBytes(StandardCharsets.US_ASCII));
            ((OutputStream)out).flush();
            byte[] data = new byte[this.getChunkSize()];
            int contentRead = content.read(data);
            while (contentRead > 0) {
                byte[] lengthIndicator = ByteBuffer.allocate(4).putInt(contentRead).array();
                ((OutputStream)out).write(lengthIndicator);
                ((OutputStream)out).write(data, 0, contentRead);
                if (in.available() > 0) {
                    String scanReply = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.US_ASCII).trim();
                    if (!scanReply.contains(INSTREAM_SIZE_LIMIT_EXCEEDED_ERROR)) throw new AvsException("Clam responded before all data was sent: " + scanReply);
                    throw new AvsException("File too large: " + scanReply);
                }
                contentRead = content.read(data);
            }
            ((OutputStream)out).write(new byte[]{0, 0, 0, 0});
            ((OutputStream)out).flush();
            String scanReply = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.US_ASCII).trim();
            if (scanReply.contains("stream: OK")) {
                ScanResult scanResult = new ScanResult(scanReply, true);
                return scanResult;
            }
            if (scanReply.contains(INSTREAM_SIZE_LIMIT_EXCEEDED_ERROR)) {
                throw new AvsException("File too large: " + scanReply);
            }
            if (!scanReply.matches("stream: .+ FOUND")) throw new AvsException("Unknown reply from clam: " + scanReply);
            ScanResult scanResult = new ScanResult(scanReply, false);
            return scanResult;
        }
        catch (IOException e) {
            LOG.error("Error during scanning", (Throwable)e);
            throw new AvsException("Error during scanning", (Throwable)e);
        }
    }

    private Socket connect() throws AvsException {
        try {
            return new Socket(this.config.host(), this.config.port());
        }
        catch (IOException e) {
            LOG.error("Unable to connect to network scanner", (Throwable)e);
            throw new AvsException("Unable to connect to clam network scanner", (Throwable)e);
        }
    }

    private int getChunkSize() {
        if (this.config.chunkSize() > 0) {
            return this.config.chunkSize();
        }
        return 0x100000;
    }

    private int getConnectionTimeout() {
        if (this.config.timeout() > 0) {
            return this.config.timeout();
        }
        return 5;
    }
}

