/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.service;

import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.AvsService;
import de.valtech.avs.api.service.scanner.AvsScannerEnine;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.history.HistoryService;
import de.valtech.avs.core.serviceuser.ServiceResourceResolverService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={AvsService.class})
public class AvsServiceImpl
implements AvsService {
    @Reference
    private HistoryService historyService;
    @Reference
    private ServiceResourceResolverService serviceResourceResolverService;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindEngine", unbind="unbindEngine")
    private List<AvsScannerEnine> engines = new ArrayList<AvsScannerEnine>();

    protected synchronized void bindEngine(AvsScannerEnine engine) {
        this.engines.add(engine);
    }

    protected synchronized void unbindEngine(AvsScannerEnine engine) {
        this.engines.remove(engine);
    }

    public ScanResult scan(InputStream content, String userId) throws AvsException {
        return this.scan(content, userId, "");
    }

    public ScanResult scan(InputStream content, String userId, String path) throws AvsException {
        if (this.engines.isEmpty()) {
            throw new AvsException("No scanning engines available");
        }
        if (content == null) {
            return new ScanResult(null, true);
        }
        ScanResult result = null;
        try (ResourceResolver resolver = this.serviceResourceResolverService.getServiceResourceResolver();){
            for (AvsScannerEnine engine : this.engines) {
                result = engine.scan(content, path);
                result.setPath(path);
                result.setUserId(userId);
                if (result.isClean()) continue;
                this.historyService.createHistoryEntry(resolver, result);
                break;
            }
        }
        catch (LoginException e) {
            throw new AvsException("Unable to access service resolver", (Throwable)e);
        }
        return result;
    }

    public boolean hasActiveScanEngines() {
        return !this.engines.isEmpty();
    }
}

