/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.jmx;

import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.AvsService;
import de.valtech.avs.core.jmx.AntiVirusScannerMBean;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.management.NotCompliantMBeanException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AntiVirusScannerMBean.class}, immediate=true, property={"jmx.objectname=de.valtech:type=AVS", "pattern=/.*"})
public class AntiVirusScannerMBeanImpl
extends AnnotatedStandardMBean
implements AntiVirusScannerMBean {
    @Reference
    private AvsService scanner;

    public AntiVirusScannerMBeanImpl() throws NotCompliantMBeanException {
        super(AntiVirusScannerMBean.class);
    }

    @Override
    public String scanContent(String content) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8.name()));
            return this.scanner.scan((InputStream)stream, "JMX").toString();
        }
        catch (AvsException | UnsupportedEncodingException e) {
            return "Error: " + e.getMessage();
        }
    }
}

