/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.history;

import de.valtech.avs.api.history.HistoryEntry;
import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.history.HistoryEntryImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HistoryService.class})
public class HistoryService {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryService.class);
    public static final String HISTORY_BASE = "/var/avs/history";
    protected static final String ATTR_TIME = "time";
    protected static final String ATTR_CLEAN = "clean";
    protected static final String ATTR_OUTPUT = "output";
    protected static final String ATTR_PATH = "path";
    protected static final String ATTR_USER_ID = "userId";
    private static final String NAME_INDEX = "oak:index";
    private Random random = new Random();

    public void createHistoryEntry(ResourceResolver resolver, ScanResult result) throws AvsException {
        GregorianCalendar now = new GregorianCalendar();
        String basePath = "/var/avs/history/" + now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
        String nodeName = this.generateHistoryNodeName();
        String nodePath = basePath + "/" + nodeName;
        this.createPath(basePath, resolver, "sling:OrderedFolder");
        this.createPath(nodePath, resolver, "nt:unstructured");
        Resource resource = resolver.getResource(nodePath);
        ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        values.put((Object)ATTR_TIME, (Object)now);
        values.put((Object)ATTR_OUTPUT, (Object)result.getOutput());
        values.put((Object)ATTR_CLEAN, (Object)result.isClean());
        values.put((Object)ATTR_PATH, (Object)result.getPath());
        values.put((Object)ATTR_USER_ID, (Object)result.getUserId());
        try {
            resolver.commit();
        }
        catch (PersistenceException e) {
            throw new AvsException("Unable to story history entry", (Throwable)e);
        }
    }

    public List<HistoryEntry> getHistory(int startIndex, int count, ResourceResolver resolver) {
        int i;
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        if (count == 0) {
            return entries;
        }
        Resource base = resolver.getResource(HISTORY_BASE);
        Resource current = this.getLatestHistoryEntry(base);
        if (current == null) {
            return entries;
        }
        for (i = 0; i < startIndex; ++i) {
            current = this.getPreviousHistoryEntry(current);
        }
        for (i = 0; i < count && current != null; ++i) {
            entries.add(this.readHistoryEntry(current));
            current = this.getPreviousHistoryEntry(current);
        }
        return entries;
    }

    private Resource getPreviousHistoryEntry(Resource current) {
        Resource previous = this.getPreviousSibling(current);
        if (previous != null) {
            return previous;
        }
        Resource base = this.descendToPreviousSiblingInHistory(current.getParent());
        return this.ascendToLastRun(base);
    }

    private Resource ascendToLastRun(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource last = this.getLastChild(resource);
        if (last == null) {
            return null;
        }
        ValueMap values = (ValueMap)last.adaptTo(ValueMap.class);
        if ("sling:OrderedFolder".equals(values.get("jcr:primaryType", String.class))) {
            return this.ascendToLastRun(last);
        }
        return last;
    }

    private Resource descendToPreviousSiblingInHistory(Resource current) {
        if (current == null || HISTORY_BASE.equals(current.getPath())) {
            return null;
        }
        Resource previous = this.getPreviousSibling(current);
        if (previous != null) {
            return previous;
        }
        previous = this.descendToPreviousSiblingInHistory(current.getParent());
        return previous;
    }

    private Resource getPreviousSibling(Resource resource) {
        Resource sibling;
        Iterator siblings = resource.getParent().listChildren();
        Resource previous = null;
        while (siblings.hasNext() && !(sibling = (Resource)siblings.next()).getName().equals(resource.getName())) {
            if (sibling.getName().equals("rep:policy") || sibling.getName().equals(NAME_INDEX)) continue;
            previous = sibling;
        }
        return previous;
    }

    private Resource getLatestHistoryEntry(Resource base) {
        if (base == null) {
            return null;
        }
        return this.ascendToLastRun(base);
    }

    private Resource getLastChild(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource last = null;
        Iterator lastIterator = resource.listChildren();
        while (lastIterator.hasNext()) {
            Resource candidate = (Resource)lastIterator.next();
            if ("rep:policy".equals(candidate.getName()) || NAME_INDEX.equals(candidate.getName())) continue;
            last = candidate;
        }
        return last;
    }

    private HistoryEntry readHistoryEntry(Resource resource) {
        ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
        boolean clean = (Boolean)values.get(ATTR_CLEAN, (Object)false);
        String output = (String)values.get(ATTR_OUTPUT, (Object)"");
        String path = (String)values.get(ATTR_PATH, (Object)"");
        String userId = (String)values.get(ATTR_USER_ID, (Object)"");
        Calendar date = (Calendar)values.get(ATTR_TIME, Calendar.class);
        return new HistoryEntryImpl(date.getTime(), output, clean, path, resource.getPath(), userId);
    }

    protected void createPath(String path, ResourceResolver resolver, String primaryType) throws AvsException {
        Resource folder = resolver.getResource(path);
        if (folder == null) {
            String parent = path.substring(0, path.lastIndexOf(47));
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (resolver.getResource(parent) == null) {
                this.createPath(parent, resolver, primaryType);
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("jcr:primaryType", primaryType);
            try {
                resolver.create(resolver.getResource(parent), name, properties);
            }
            catch (PersistenceException e) {
                throw new AvsException("Unable to create " + path, (Throwable)e);
            }
        }
    }

    private String generateHistoryNodeName() {
        return System.currentTimeMillis() + "" + this.random.nextInt(100000);
    }

    public void purgeHistory(ResourceResolver resolver, int daysToKeep) throws PersistenceException {
        Resource base = resolver.getResource(HISTORY_BASE);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, -daysToKeep);
        LOG.debug("Starting purge with limit {}", (Object)calendar.getTime());
        this.deleteRecursive(base.listChildren(), calendar, new int[]{1, 2, 5});
    }

    private void deleteRecursive(Iterator<Resource> resources, Calendar calendar, int[] fields) throws PersistenceException {
        int currentField = fields[0];
        while (resources.hasNext()) {
            Resource resource = resources.next();
            String name = resource.getName();
            if (!StringUtils.isNumeric((CharSequence)name)) {
                LOG.debug("Skipping purge of other node: {}", (Object)resource.getPath());
                continue;
            }
            int nodeValue = Integer.parseInt(name);
            int limit = calendar.get(currentField);
            if (currentField == 2) {
                ++limit;
            }
            if (nodeValue > limit) {
                LOG.debug("Skipping purge of too young node: {}", (Object)resource.getPath());
                continue;
            }
            if (nodeValue == limit) {
                LOG.debug("Skipping purge of too young node: {}", (Object)resource.getPath());
                if (fields.length == 1) {
                    return;
                }
                int[] fieldsNew = new int[fields.length - 1];
                System.arraycopy(fields, 1, fieldsNew, 0, fieldsNew.length);
                this.deleteRecursive(resource.listChildren(), calendar, fieldsNew);
                continue;
            }
            LOG.debug("Purging node: {}", (Object)resource.getPath());
            ResourceUtil.BatchResourceRemover remover = ResourceUtil.getBatchResourceRemover((int)1000);
            remover.delete(resource);
        }
    }

    public void selfCheck(ResourceResolver resolver) throws AvsException {
        Resource base = resolver.getResource(HISTORY_BASE);
        if (base == null) {
            throw new AvsException("/var/avs/history does not exist or is not accessible.");
        }
    }
}

