/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.healthcheck;

import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.AvsService;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.serviceuser.ServiceResourceResolverService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthCheck.class}, property={"hc.tags=avs", "hc.name=AVS Self Check", "hc.mbean.name=avsSelfCheckHCmBean"})
public class SelfCheckHealthCheck
implements HealthCheck {
    @Reference
    private ServiceResourceResolverService resolverService;
    @Reference
    private AvsService avsService;

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        this.checkServiceResolver(resultLog);
        if (resultLog.getAggregateStatus().equals((Object)Result.Status.CRITICAL)) {
            return new Result((ResultLog)resultLog);
        }
        this.checkActiveScannersAvailable(resultLog);
        return new Result((ResultLog)resultLog);
    }

    private void checkServiceResolver(FormattingResultLog resultLog) {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            if (resolver == null) {
                resultLog.critical("Unable to open service resource resolver: null", new Object[0]);
                return;
            }
            resultLog.info("Service user ok", new Object[0]);
        }
        catch (LoginException e) {
            resultLog.critical("Unable to open service resource resolver {}", new Object[]{e.getMessage()});
        }
    }

    private void checkActiveScannersAvailable(FormattingResultLog resultLog) {
        if (!this.avsService.hasActiveScanEngines()) {
            resultLog.critical("No active scan engines available", new Object[0]);
        } else {
            resultLog.info("At least one active scan engine available", new Object[0]);
            this.checkSampleScan(resultLog);
        }
    }

    private void checkSampleScan(FormattingResultLog resultLog) {
        ByteArrayInputStream stream = new ByteArrayInputStream(SelfCheckHealthCheck.class.getName().getBytes());
        try {
            ScanResult result = this.avsService.scan((InputStream)stream, "HEALTH CHECK");
            if (result.isClean()) {
                resultLog.info("Test scan ok", new Object[0]);
            } else {
                resultLog.critical("False positive result: {}", new Object[]{result.getOutput()});
            }
        }
        catch (AvsException e) {
            resultLog.critical("Error running test scan: {}", new Object[]{e.getMessage()});
        }
    }
}

