/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.filter;

import com.adobe.granite.security.user.UserProperties;
import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.AvsService;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.filter.AvsPostFilterConfig;
import de.valtech.avs.core.filter.PartWrapper;
import de.valtech.avs.core.history.HistoryService;
import de.valtech.avs.core.mail.AvsNotificationMailer;
import de.valtech.avs.core.serviceuser.ServiceResourceResolverService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"sling.filter.scope=REQUEST", "service.ranking:Integer=50000"})
@Designate(ocd=AvsPostFilterConfig.class)
public class AvsPostFilter
implements Filter {
    private static final String REQUEST_PARTS = "request-parts-iterator";
    private static final Logger LOG = LoggerFactory.getLogger(AvsPostFilter.class);
    @Reference
    private AvsService avsService;
    @Reference
    private HistoryService historyService;
    @Reference
    private ServiceResourceResolverService serviceResolverService;
    @Reference
    private AvsNotificationMailer mailer;
    private List<Pattern> includePatterns = new ArrayList<Pattern>();
    private List<Pattern> excludePatterns = new ArrayList<Pattern>();

    @Activate
    public void activate(AvsPostFilterConfig config) {
        this.excludePatterns = new ArrayList<Pattern>();
        if (config.excludePatterns() != null) {
            for (String patternString : config.excludePatterns()) {
                this.excludePatterns.add(Pattern.compile(patternString));
            }
        }
        this.includePatterns = new ArrayList<Pattern>();
        if (config.includePatterns() != null) {
            for (String patternString : config.includePatterns()) {
                this.includePatterns.add(Pattern.compile(patternString));
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String contentType = slingRequest.getContentType();
        if (!"POST".equals(slingRequest.getMethod()) || !this.isMultipartRequest(contentType) || this.isUrlToIgnore(slingRequest)) {
            chain.doFilter(request, response);
            return;
        }
        Iterator parts = (Iterator)request.getAttribute(REQUEST_PARTS);
        if (parts == null) {
            chain.doFilter(request, response);
            return;
        }
        ArrayList<File> parameterFiles = new ArrayList<File>();
        ArrayList<PartWrapper> newParts = new ArrayList<PartWrapper>();
        ArrayList<String> fileNames = new ArrayList<String>();
        while (parts.hasNext()) {
            Part part = (Part)parts.next();
            String partContentType = part.getContentType();
            if (StringUtils.isEmpty((CharSequence)partContentType)) {
                String partContent = IOUtils.toString((InputStream)part.getInputStream(), (String)StandardCharsets.UTF_8.name());
                newParts.add(new PartWrapper(part, partContent.getBytes(StandardCharsets.UTF_8.name())));
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)part.getSubmittedFileName())) {
                fileNames.add(this.getFilePath(slingRequest, part));
            }
            InputStream partStream = part.getInputStream();
            File file = File.createTempFile("valtech-avs", ".tmp");
            Files.copy(partStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            partStream.close();
            parameterFiles.add(file);
            PartWrapper wrapper = new PartWrapper(part, file);
            newParts.add(wrapper);
        }
        request.setAttribute(REQUEST_PARTS, newParts.iterator());
        ArrayList<FileInputStream> streams = new ArrayList<FileInputStream>();
        for (File file : parameterFiles) {
            streams.add(new FileInputStream(file));
        }
        if (streams.isEmpty()) {
            chain.doFilter(request, response);
            return;
        }
        SequenceInputStream combinedStream = new SequenceInputStream(Collections.enumeration(streams));
        try {
            Session session = (Session)slingRequest.getResourceResolver().adaptTo(Session.class);
            String userId = session != null ? session.getUserID() : "";
            ScanResult result = this.avsService.scan((InputStream)combinedStream, userId, String.join((CharSequence)", ", fileNames));
            if (!result.isClean()) {
                for (File file : parameterFiles) {
                    if (file.delete()) continue;
                    LOG.warn("Unable to remove temp file {}", (Object)file.getPath());
                }
                this.sendEmail(slingRequest, result, fileNames);
                throw new ServletException("Uploaded file contains a virus");
            }
        }
        catch (AvsException e) {
            LOG.error("Virus scan failed", (Throwable)e);
        }
        combinedStream.close();
        chain.doFilter(request, response);
    }

    private String getFilePath(SlingHttpServletRequest slingRequest, Part part) {
        String fileName = part.getSubmittedFileName();
        String path = StringUtils.isNotBlank((CharSequence)slingRequest.getRequestURI()) ? slingRequest.getRequestURI() + "/" : "";
        path = path.replace(".createasset.html", "");
        return path + fileName;
    }

    private boolean isMultipartRequest(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        return contentType.contains("multipart/form-data");
    }

    protected boolean isUrlToIgnore(SlingHttpServletRequest request) {
        String url = request.getRequestURI();
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(url).matches()) continue;
            return true;
        }
        if (this.includePatterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(url).matches()) continue;
            return false;
        }
        return true;
    }

    private void sendEmail(SlingHttpServletRequest slingRequest, ScanResult result, List<String> fileNames) {
        UserProperties properties = (UserProperties)slingRequest.adaptTo(UserProperties.class);
        ArrayList<String> emails = new ArrayList<String>();
        try {
            if (properties != null && StringUtils.isNotEmpty((CharSequence)properties.getProperty("email"))) {
                emails.add(properties.getProperty("email"));
            }
        }
        catch (RepositoryException e) {
            LOG.error("Cannot read email of user", (Throwable)e);
        }
        if (emails.isEmpty()) {
            return;
        }
        this.mailer.sendEmail(emails, String.join((CharSequence)", ", fileNames), result);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

