/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.model.scan;

import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.AvsService;
import de.valtech.avs.api.service.scanner.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class ScanModel {
    private static final String FILE_PART = "scanfile";
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService
    private AvsService avsService;
    private boolean scanDone = false;
    private String resultOutput;
    private boolean scanFailed = false;
    private boolean clean = true;

    @PostConstruct
    protected void init() {
        try {
            InputStream inputStream;
            Part filePart = this.request.getPart(FILE_PART);
            if (filePart != null && (inputStream = filePart.getInputStream()) != null) {
                this.scanDone = true;
                String userId = ((Session)this.request.getResourceResolver().adaptTo(Session.class)).getUserID();
                ScanResult result = this.avsService.scan(inputStream, userId, filePart.getSubmittedFileName());
                this.clean = result.isClean();
                this.resultOutput = result.getOutput();
            }
        }
        catch (AvsException | IOException | ServletException e) {
            this.scanFailed = true;
            this.resultOutput = e.getMessage();
        }
    }

    public String getResult() {
        return this.resultOutput;
    }

    public boolean isScanDone() {
        return this.scanDone;
    }

    public boolean isScanFailed() {
        return this.scanFailed;
    }

    public boolean isClean() {
        return this.clean;
    }
}

