/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.service.scanner;

import de.valtech.avs.api.service.AvsException;
import de.valtech.avs.api.service.scanner.AvsScannerEnine;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.service.scanner.ClamScannerConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AvsScannerEnine.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=ClamScannerConfig.class)
public class ClamScannerEngine
implements AvsScannerEnine {
    private static final Logger LOG = LoggerFactory.getLogger(ClamScannerEngine.class);
    private ClamScannerConfig config;

    @Activate
    public void activate(ClamScannerConfig config) {
        this.config = config;
    }

    public ScanResult scan(InputStream content, String fileName) throws AvsException {
        try {
            File tempFile = this.createTemporaryFile(content);
            Runtime runtime = Runtime.getRuntime();
            String command = this.config.command() + " " + tempFile.getPath();
            Process process = runtime.exec(command);
            InputStream in = process.getInputStream();
            InputStream err = process.getErrorStream();
            int returnCode = process.waitFor();
            String output = IOUtils.toString((InputStream)in, (Charset)Charset.forName(StandardCharsets.UTF_8.name()));
            String error = IOUtils.toString((InputStream)err, (Charset)Charset.forName(StandardCharsets.UTF_8.name()));
            in.close();
            err.close();
            output = StringUtils.isBlank((CharSequence)fileName) ? output.replace(tempFile.getPath(), "SCANNED_FILE") : output.replace(tempFile.getPath(), fileName);
            Files.delete(Paths.get(tempFile.getPath(), new String[0]));
            if (returnCode == 0 && StringUtils.isBlank((CharSequence)error)) {
                return new ScanResult(output, true);
            }
            return new ScanResult(output + "\n" + error, false);
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Error during scanning", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new AvsException("Error during scanning", (Throwable)e);
        }
    }

    private File createTemporaryFile(InputStream content) throws IOException {
        File file = File.createTempFile("valtech-avs", ".tmp");
        Files.copy(content, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        content.close();
        return file;
    }
}

