/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.healthcheck;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.installhook.HookExecutionHistory;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthCheck.class}, property={"hc.tags=aecu", "hc.name=AECU Self Check", "hc.mbean.name=aecuSelfCheckHCmBean"})
public class SelfCheckHealthCheck
implements HealthCheck {
    @Reference
    private ServiceResourceResolverService resolverService;
    @Reference
    private HistoryUtil historyUtil;

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        this.checkServiceResolver(resultLog);
        if (resultLog.getAggregateStatus().equals((Object)Result.Status.CRITICAL)) {
            return new Result((ResultLog)resultLog);
        }
        this.checkHistoryNodeAccess(resultLog);
        this.checkHookHistoryNodeAccess(resultLog);
        return new Result((ResultLog)resultLog);
    }

    private void checkHistoryNodeAccess(FormattingResultLog resultLog) {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            this.historyUtil.selfCheck(resolver);
            resultLog.info("History node ok", new Object[0]);
        }
        catch (AecuException | LoginException e) {
            resultLog.critical("History node check failed: {}", new Object[]{e.getMessage()});
        }
    }

    private void checkHookHistoryNodeAccess(FormattingResultLog resultLog) {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            HookExecutionHistory.selfCheck(resolver);
            resultLog.info("Install hook history node ok", new Object[0]);
        }
        catch (AecuException | LoginException e) {
            resultLog.critical("Install hook history node check failed: {}", new Object[]{e.getMessage()});
        }
    }

    private void checkServiceResolver(FormattingResultLog resultLog) {
        Throwable throwable;
        ResourceResolver resolver;
        try {
            resolver = this.resolverService.getServiceResourceResolver();
            throwable = null;
            try {
                if (resolver == null) {
                    resultLog.critical("Unable to open service resource resolver: null", new Object[0]);
                    return;
                }
                resultLog.info("Service user ok", new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resolver != null) {
                    if (throwable != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resolver.close();
                    }
                }
            }
        }
        catch (LoginException e) {
            resultLog.critical("Unable to open service resource resolver {}", new Object[]{e.getMessage()});
        }
        try {
            resolver = this.resolverService.getContentMigratorResourceResolver();
            throwable = null;
            try {
                if (resolver == null) {
                    resultLog.critical("Unable to open migration resource resolver: null", new Object[0]);
                    return;
                }
                resultLog.info("Migration user ok", new Object[0]);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (resolver != null) {
                    if (throwable != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        resolver.close();
                    }
                }
            }
        }
        catch (LoginException e) {
            resultLog.critical("Unable to open migration resource resolver {}", new Object[]{e.getMessage()});
        }
    }
}

