/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.properties;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class JoinProperty
implements Action {
    protected String name;
    protected String separator;
    protected Object emptyValue;

    public JoinProperty(@Nonnull String name) {
        this(name, null, ",");
    }

    public JoinProperty(@Nonnull String name, Object emptyValue) {
        this(name, emptyValue, ",");
    }

    public JoinProperty(@Nonnull String name, Object emptyValue, @Nonnull String separator) {
        this.name = name;
        this.separator = separator;
        this.emptyValue = emptyValue;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (properties == null) {
            return "WARNING: could not get ModifiableValueMap for resource " + resource.getPath();
        }
        if (!properties.containsKey((Object)this.name)) {
            return "";
        }
        Object value = properties.get((Object)this.name);
        if (!value.getClass().isArray()) {
            return "";
        }
        Object[] values = (Object[])value;
        if (values.length > 0) {
            Node node = (Node)resource.adaptTo(Node.class);
            try {
                node.getProperty(this.name).remove();
                node.setProperty(this.name, StringUtils.join((Object[])values, (String)this.separator));
            }
            catch (RepositoryException e) {
                throw new PersistenceException(e.getMessage(), (Throwable)e);
            }
            return "Joined " + value.getClass().getSimpleName() + " property " + this.name + " for resource " + resource.getPath();
        }
        if (this.emptyValue == null) {
            properties.remove((Object)this.name);
            return "Removed empty " + value.getClass().getSimpleName() + " property " + this.name + " for resource " + resource.getPath();
        }
        properties.remove((Object)this.name);
        properties.put((Object)this.name, this.emptyValue);
        return "Replaced empty " + value.getClass().getSimpleName() + " property " + this.name + " with " + this.emptyValue + " for resource " + resource.getPath();
    }
}

