/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.util.Iterator;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class TreeActivatePageAction
implements Action {
    private boolean skipDeactivated;
    private BindingContext context;
    private int count = 0;

    public TreeActivatePageAction(boolean skipDeactivated, BindingContext context) {
        this.skipDeactivated = skipDeactivated;
        this.context = context;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException, AecuException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        String skip = this.skipDeactivated ? "skipping" : "not skipping";
        try {
            this.performActivation(page);
        }
        catch (ReplicationException e) {
            throw new PersistenceException("Unable to replicate tree " + page.getPath(), (Throwable)e);
        }
        return "Replicated page tree " + page.getPath() + " " + skip + " deactivated pages (" + this.count + " pages)";
    }

    private void performActivation(Page page) throws ReplicationException {
        ReplicationStatus status;
        if (this.skipDeactivated && (status = (ReplicationStatus)page.adaptTo(ReplicationStatus.class)) != null && status.isDeactivated()) {
            return;
        }
        this.activate(page);
        Iterator childIterator = page.listChildren();
        while (childIterator.hasNext()) {
            this.performActivation((Page)childIterator.next());
        }
    }

    private void activate(Page page) throws ReplicationException {
        ++this.count;
        if (this.context.isDryRun()) {
            return;
        }
        Session session = (Session)this.context.getResolver().adaptTo(Session.class);
        this.context.getReplicator().replicate(session, ReplicationActionType.ACTIVATE, page.getPath());
    }
}

