/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class RenameResource
implements Action {
    private ResourceResolver resourceResolver;
    private String newName;

    public RenameResource(@Nonnull ResourceResolver resourceResolver, @Nonnull String newName) {
        this.resourceResolver = resourceResolver;
        this.newName = newName;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        String path = resource.getPath();
        if (resource.getName().equals(this.newName)) {
            return "Resource " + path + " already has new name, no renaming done";
        }
        Session session = (Session)this.resourceResolver.adaptTo(Session.class);
        String newPath = resource.getParent().getPath() + "/" + this.newName;
        try {
            session.move(path, newPath);
        }
        catch (ItemExistsException e) {
            throw new PersistenceException("Target path already exists", (Throwable)e);
        }
        catch (PathNotFoundException e) {
            throw new PersistenceException("Target path does not exist", (Throwable)e);
        }
        catch (VersionException e) {
            throw new PersistenceException("Version error", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Rename failed", (Throwable)e);
        }
        return "Renamed resource " + path + " to " + this.newName;
    }
}

