/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

public class BaseServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -5240930544859160292L;
    protected static final String ERROR_MESSAGE_INTERNAL_SERVER = "Internal Server Error";

    protected void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
    }

    protected void writeResult(SlingHttpServletResponse response, String json, int status) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setStatus(status);
        response.getWriter().write(json);
    }

    protected void writeResult(SlingHttpServletResponse response, String json) throws IOException {
        this.writeResult(response, json, 200);
    }

    protected void sendInternalServerError(SlingHttpServletResponse response) throws IOException {
        this.writeResult(response, ERROR_MESSAGE_INTERNAL_SERVER, 500);
    }

    protected boolean validateParameter(String param) {
        return param != null && StringUtils.isNotEmpty((CharSequence)param);
    }
}

