/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.model.history;

import de.valtech.aecu.api.service.HistoryEntry;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={Resource.class})
public class HistoryDataItem {
    private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @SlingObject
    private Resource resource;
    private HistoryEntry history = null;

    @PostConstruct
    public void setup() {
        this.history = (HistoryEntry)this.resource.getValueMap().get("history", HistoryEntry.class);
    }

    public String getDate() {
        if (this.history.getEnd() == null) {
            return this.format.format(this.history.getStart());
        }
        return this.format.format(this.history.getEnd());
    }

    public String getDuration() {
        if (!HistoryEntry.STATE.FINISHED.equals((Object)this.history.getState())) {
            return "";
        }
        Duration duration = Duration.between(this.history.getStart().toInstant(), this.history.getEnd().toInstant());
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            return duration.getSeconds() + "s";
        }
        return duration.getNano() / 1000000 + "ms";
    }

    public String getStatusIcon() {
        if (HistoryEntry.RESULT.FAILURE.equals((Object)this.history.getResult())) {
            return "closeCircle";
        }
        if (HistoryEntry.RESULT.SUCCESS.equals((Object)this.history.getResult())) {
            return "checkCircle";
        }
        return "clock";
    }

    public String getStatusColor() {
        if (HistoryEntry.RESULT.FAILURE.equals((Object)this.history.getResult())) {
            return "fail";
        }
        if (HistoryEntry.RESULT.SUCCESS.equals((Object)this.history.getResult())) {
            return "ok";
        }
        return "inprogress";
    }

    public String getPath() {
        return this.history.getRepositoryPath();
    }

    public int getScriptCount() {
        if (this.history.getSingleResults() == null) {
            return 0;
        }
        return this.history.getSingleResults().size();
    }
}

