/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.history;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.service.HistoryEntryImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HistoryUtil.class})
public class HistoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryUtil.class);
    protected static final String HISTORY_BASE = "/var/aecu";
    protected static final String NODE_FALLBACK = "fallback";
    protected static final String ATTR_PATH = "path";
    protected static final String ATTR_RUN_OUTPUT = "runOutput";
    protected static final String ATTR_RUN_STATE = "runState";
    protected static final String ATTR_RUN_RESULT = "runResult";
    protected static final String ATTR_RUN_TIME = "runTime";
    protected static final String ATTR_RESULT = "result";
    protected static final String ATTR_STATE = "state";
    protected static final String ATTR_START = "start";
    protected static final String ATTR_END = "end";
    private Random random = new Random();

    public HistoryEntry createHistoryEntry(ResourceResolver resolver) throws AecuException {
        HistoryEntryImpl history = new HistoryEntryImpl();
        GregorianCalendar start = new GregorianCalendar();
        String basePath = "/var/aecu/" + start.get(1) + "/" + (start.get(2) + 1) + "/" + start.get(5);
        String nodeName = this.generateHistoryNodeName();
        String nodePath = basePath + "/" + nodeName;
        this.createPath(basePath, resolver, "sling:OrderedFolder");
        this.createPath(nodePath, resolver, "nt:unstructured");
        Resource resource = resolver.getResource(nodePath);
        ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        values.put((Object)ATTR_START, (Object)start);
        values.put((Object)ATTR_STATE, (Object)HistoryEntry.STATE.RUNNING.name());
        values.put((Object)ATTR_RESULT, (Object)HistoryEntry.RESULT.UNKNOWN.name());
        history.setStart(start.getTime());
        history.setRepositoryPath(nodePath);
        history.setState(HistoryEntry.STATE.RUNNING);
        return history;
    }

    public void storeExecutionInHistory(HistoryEntry history, ExecutionResult result, ResourceResolver resolver) throws AecuException {
        String path = history.getRepositoryPath() + "/" + history.getSingleResults().size();
        this.saveExecutionResultInHistory(result, path, resolver);
    }

    public void finishHistoryEntry(HistoryEntry history, ResourceResolver resolver) {
        Resource resource = resolver.getResource(history.getRepositoryPath());
        ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        GregorianCalendar end = new GregorianCalendar();
        values.put((Object)ATTR_END, (Object)end);
        values.put((Object)ATTR_STATE, (Object)HistoryEntry.STATE.FINISHED.name());
        values.put((Object)ATTR_RESULT, (Object)history.getResult().name());
        ((HistoryEntryImpl)history).setEnd(end.getTime());
        ((HistoryEntryImpl)history).setState(HistoryEntry.STATE.FINISHED);
    }

    public List<HistoryEntry> getHistory(int startIndex, int count, ResourceResolver resolver) {
        int i;
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        if (count == 0) {
            return entries;
        }
        Resource base = resolver.getResource(HISTORY_BASE);
        Resource current = this.getLatestHistoryEntry(base);
        if (current == null) {
            return entries;
        }
        for (i = 0; i < startIndex; ++i) {
            current = this.getPreviousHistoryEntry(current);
        }
        for (i = 0; i < count && current != null; ++i) {
            entries.add(this.readHistoryEntry(current));
            current = this.getPreviousHistoryEntry(current);
        }
        return entries;
    }

    private Resource getPreviousHistoryEntry(Resource current) {
        Resource previous = this.getPreviousSibling(current);
        if (previous != null) {
            return previous;
        }
        Resource base = this.descendToPreviousSiblingInHistory(current.getParent());
        return this.ascendToLastRun(base);
    }

    private Resource ascendToLastRun(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource last = this.getLastChild(resource);
        if (last == null) {
            return null;
        }
        ValueMap values = (ValueMap)last.adaptTo(ValueMap.class);
        if ("sling:OrderedFolder".equals(values.get("jcr:primaryType", String.class))) {
            return this.ascendToLastRun(last);
        }
        return last;
    }

    private Resource descendToPreviousSiblingInHistory(Resource current) {
        if (current == null || HISTORY_BASE.equals(current.getPath())) {
            return null;
        }
        Resource previous = this.getPreviousSibling(current);
        if (previous != null) {
            return previous;
        }
        previous = this.descendToPreviousSiblingInHistory(current.getParent());
        return previous;
    }

    private Resource getPreviousSibling(Resource resource) {
        Resource sibling;
        Iterator siblings = resource.getParent().listChildren();
        Resource previous = null;
        while (siblings.hasNext() && !(sibling = (Resource)siblings.next()).getName().equals(resource.getName())) {
            if (sibling.getName().equals("rep:policy")) continue;
            previous = sibling;
        }
        return previous;
    }

    private Resource getLatestHistoryEntry(Resource base) {
        if (base == null) {
            return null;
        }
        return this.ascendToLastRun(base);
    }

    private Resource getLastChild(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource last = null;
        Iterator lastIterator = resource.listChildren();
        while (lastIterator.hasNext()) {
            Resource candidate = (Resource)lastIterator.next();
            if ("rep:policy".equals(candidate.getName())) continue;
            last = candidate;
        }
        return last;
    }

    public HistoryEntry readHistoryEntry(Resource resource) {
        HistoryEntryImpl entry = new HistoryEntryImpl();
        entry.setRepositoryPath(resource.getPath());
        ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
        if (values.containsKey((Object)ATTR_STATE)) {
            entry.setState(HistoryEntry.STATE.valueOf((String)((String)values.get(ATTR_STATE, String.class))));
        }
        if (values.containsKey((Object)ATTR_START)) {
            entry.setStart(((Calendar)values.get(ATTR_START, Calendar.class)).getTime());
        }
        if (values.containsKey((Object)ATTR_END)) {
            entry.setEnd(((Calendar)values.get(ATTR_END, Calendar.class)).getTime());
        }
        Iterable children = resource.getChildren();
        for (Resource child : children) {
            entry.getSingleResults().add(this.readHistorySingleResult(child));
        }
        return entry;
    }

    private ExecutionResult readHistorySingleResult(Resource resource) {
        ExecutionResult fallback = null;
        Resource fallbackResource = resource.getChild(NODE_FALLBACK);
        if (fallbackResource != null) {
            fallback = this.readHistorySingleResult(fallbackResource);
        }
        ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
        String output = (String)values.get(ATTR_RUN_OUTPUT, (Object)"");
        String time = (String)values.get(ATTR_RUN_TIME, (Object)"");
        ExecutionState state = ExecutionState.valueOf((String)((String)values.get(ATTR_RUN_STATE, (Object)ExecutionState.FAILED.name())));
        String runResult = (String)values.get(ATTR_RUN_RESULT, (Object)"");
        String path = (String)values.get(ATTR_PATH, (Object)"");
        ExecutionResult result = new ExecutionResult(state, time, runResult, output, fallback, path);
        return result;
    }

    private void saveExecutionResultInHistory(ExecutionResult result, String path, ResourceResolver resolver) throws AecuException {
        this.createPath(path, resolver, "nt:unstructured");
        Resource entry = resolver.getResource(path);
        ModifiableValueMap values = (ModifiableValueMap)entry.adaptTo(ModifiableValueMap.class);
        values.put((Object)ATTR_RUN_STATE, (Object)result.getState().name());
        values.put((Object)ATTR_PATH, (Object)result.getPath());
        if (StringUtils.isNotBlank((CharSequence)result.getOutput())) {
            values.put((Object)ATTR_RUN_OUTPUT, (Object)result.getOutput());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getResult())) {
            values.put((Object)ATTR_RUN_RESULT, (Object)result.getResult());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getTime())) {
            values.put((Object)ATTR_RUN_TIME, (Object)result.getTime());
        }
        if (result.getFallbackResult() != null) {
            String fallbackPath = path + "/" + NODE_FALLBACK;
            this.saveExecutionResultInHistory(result.getFallbackResult(), fallbackPath, resolver);
        }
    }

    protected void createPath(String path, ResourceResolver resolver, String primaryType) throws AecuException {
        Resource folder = resolver.getResource(path);
        if (folder == null) {
            String parent = path.substring(0, path.lastIndexOf("/"));
            String name = path.substring(path.lastIndexOf("/") + 1);
            if (resolver.getResource(parent) == null) {
                this.createPath(parent, resolver, primaryType);
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("jcr:primaryType", primaryType);
            try {
                resolver.create(resolver.getResource(parent), name, properties);
            }
            catch (PersistenceException e) {
                throw new AecuException("Unable to create " + path, (Throwable)e);
            }
        }
    }

    private String generateHistoryNodeName() {
        return System.currentTimeMillis() + "" + this.random.nextInt(100000);
    }

    public void purgeHistory(ResourceResolver resolver, int daysToKeep) throws PersistenceException {
        Resource base = resolver.getResource(HISTORY_BASE);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, -daysToKeep);
        LOG.debug("Starting purge with limit " + calendar.getTime().toString());
        this.deleteRecursive(base.listChildren(), calendar, new int[]{1, 2, 5});
    }

    private void deleteRecursive(Iterator<Resource> resources, Calendar calendar, int[] fields) throws PersistenceException {
        int currentField = fields[0];
        while (resources.hasNext()) {
            Resource resource = resources.next();
            String name = resource.getName();
            if (!StringUtils.isNumeric((CharSequence)name)) {
                LOG.debug("Skipping purge of other node: " + resource.getPath());
                continue;
            }
            int nodeValue = Integer.parseInt(name);
            int limit = calendar.get(currentField);
            if (currentField == 2) {
                ++limit;
            }
            if (nodeValue > limit) {
                LOG.debug("Skipping purge of too young node: " + resource.getPath());
                continue;
            }
            if (nodeValue == limit) {
                LOG.debug("Skipping purge of too young node: " + resource.getPath());
                if (fields.length == 1) {
                    return;
                }
                int[] fieldsNew = new int[fields.length - 1];
                System.arraycopy(fields, 1, fieldsNew, 0, fieldsNew.length);
                this.deleteRecursive(resource.listChildren(), calendar, fieldsNew);
                continue;
            }
            LOG.debug("Purging node: " + resource.getPath());
            ResourceUtil.BatchResourceRemover remover = ResourceUtil.getBatchResourceRemover((int)1000);
            remover.delete(resource);
        }
    }

    public void selfCheck(ResourceResolver resolver) throws AecuException {
        Resource base = resolver.getResource(HISTORY_BASE);
        if (base == null) {
            throw new AecuException("/var/aecu does not exist or is not accessible.");
        }
    }
}

