/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForResources
extends TraversData {
    private String[] paths;

    public ForResources(@Nonnull String[] paths) {
        this.paths = paths;
    }

    @Override
    public void traverse(@Nonnull BindingContext context, FilterBy filter, @Nonnull List<Action> actions, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException, AecuException {
        ResourceResolver resourceResolver = context.getResolver();
        for (String path : this.paths) {
            if (path == null) continue;
            Resource resource = resourceResolver.getResource(path);
            if (resource == null) {
                stringBuffer.append("WARNING: resource does not exist " + path + "\n");
                continue;
            }
            this.applyActionsOnResource(resource, filter, actions, stringBuffer);
        }
        if (!dryRun) {
            resourceResolver.commit();
        }
    }
}

