/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.impl;

import de.valtech.aecu.api.groovy.console.bindings.ContentUpgrade;
import de.valtech.aecu.api.groovy.console.bindings.CustomResourceAction;
import de.valtech.aecu.api.groovy.console.bindings.filters.ANDFilter;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByHasProperty;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByMultiValuePropContains;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeName;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeNameRegex;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByPathRegex;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperties;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperty;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.AddMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.RemoveMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.ReplaceMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.AddPageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.DeletePageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.RemovePageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.RenderPageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.ReplicatePageAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.page.SetPageTagsAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintJson;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintPath;
import de.valtech.aecu.core.groovy.console.bindings.actions.print.PrintProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.CopyPropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.DeleteProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.MovePropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.RenameProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.SetProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CopyResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CustomAction;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.DeleteResource;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.MoveResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.RenameResource;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForChildResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForDescendantResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForQuery;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForResources;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.scribe.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentUpgradeImpl
implements ContentUpgrade {
    private static Logger LOG = LoggerFactory.getLogger(ContentUpgrade.class);
    private BindingContext context = null;
    private List<TraversData> traversals = new ArrayList<TraversData>();
    private FilterBy filter = null;
    private List<Action> actions = new ArrayList<Action>();

    public ContentUpgradeImpl(@Nonnull ResourceResolver resourceResolver) {
        this.context = new BindingContext(resourceResolver);
    }

    public ContentUpgrade forResources(@Nonnull String[] paths) {
        LOG.debug("forResources: {}", (Object)Arrays.toString(paths));
        this.traversals.add(new ForResources(paths));
        return this;
    }

    public ContentUpgrade forChildResourcesOf(@Nonnull String path) {
        LOG.debug("forChildResourcesOf: {}", (Object)path);
        this.traversals.add(new ForChildResourcesOf(path));
        return this;
    }

    public ContentUpgrade forDescendantResourcesOf(@Nonnull String path) {
        LOG.debug("forDescendantResourcesOf: {}", (Object)path);
        this.traversals.add(new ForDescendantResourcesOf(path, false));
        return this;
    }

    public ContentUpgrade forResourcesInSubtree(@Nonnull String path) {
        LOG.debug("forResourcesInSubtree: {}", (Object)path);
        this.traversals.add(new ForDescendantResourcesOf(path, true));
        return this;
    }

    public ContentUpgrade forResourcesBySql2Query(String query) {
        this.traversals.add(new ForQuery(query, "JCR-SQL2"));
        return this;
    }

    public ContentUpgrade filterByProperties(@Nonnull Map<String, Object> conditionProperties) {
        LOG.debug("filterByProperties: {}", (Object)MapUtils.toString(conditionProperties));
        this.addFilter((FilterBy)new FilterByProperties(conditionProperties));
        return this;
    }

    public ContentUpgrade filterByProperty(@Nonnull String name, Object value) {
        LOG.debug("filterByProperty: {} {}", (Object)name, value);
        this.addFilter((FilterBy)new FilterByProperty(name, value));
        return this;
    }

    public ContentUpgrade filterByHasProperty(@Nonnull String name) {
        LOG.debug("filterByHasProperty: {} {}", (Object)name);
        this.addFilter((FilterBy)new FilterByHasProperty(name));
        return this;
    }

    public ContentUpgrade filterByMultiValuePropContains(@Nonnull String name, @Nonnull Object[] conditionValues) {
        LOG.debug("filterByMultiValuePropContains {} : {}", (Object)name, (Object)Arrays.toString(conditionValues));
        this.addFilter((FilterBy)new FilterByMultiValuePropContains(name, conditionValues));
        return this;
    }

    public ContentUpgrade filterByNodeName(@Nonnull String nodeName) {
        LOG.debug("filterByNodeName: {}", (Object)nodeName);
        this.addFilter((FilterBy)new FilterByNodeName(nodeName));
        return this;
    }

    public ContentUpgrade filterByNodeNameRegex(@Nonnull String regex) {
        LOG.debug("filterByNodeNameRegex: {}", (Object)regex);
        this.addFilter((FilterBy)new FilterByNodeNameRegex(regex));
        return this;
    }

    public ContentUpgrade filterByPathRegex(@Nonnull String regex) {
        LOG.debug("filterByPathRegex: {}", (Object)regex);
        this.addFilter((FilterBy)new FilterByPathRegex(regex));
        return this;
    }

    public ContentUpgrade filterWith(@Nonnull FilterBy filter) {
        LOG.debug("filterWith: {}", (Object)filter);
        this.addFilter(filter);
        return this;
    }

    private void addFilter(@Nonnull FilterBy filter) {
        if (this.filter == null) {
            this.filter = filter;
            return;
        }
        if (this.filter instanceof ANDFilter) {
            ((ANDFilter)this.filter).addFilter(filter);
        }
        ANDFilter newFilter = new ANDFilter(Arrays.asList(this.filter, filter));
        this.filter = newFilter;
    }

    public ContentUpgrade doSetProperty(@Nonnull String name, Object value) {
        LOG.debug("doSetProperty: {} = {}", (Object)name, value);
        this.actions.add(new SetProperty(name, value));
        return this;
    }

    public ContentUpgrade doDeleteProperty(@Nonnull String name) {
        LOG.debug("doDeleteProperty: {}", (Object)name);
        this.actions.add(new DeleteProperty(name));
        return this;
    }

    public ContentUpgrade doRenameProperty(@Nonnull String oldName, @Nonnull String newName) {
        LOG.debug("doRenameProperty: {} to {}", (Object)oldName, (Object)newName);
        this.actions.add(new RenameProperty(oldName, newName));
        return this;
    }

    public ContentUpgrade doCopyPropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        LOG.debug("doCopyProperty: {} to {}", (Object)name, (Object)relativeResourcePath);
        this.actions.add(new CopyPropertyToRelativePath(name, newName, this.context.getResolver(), relativeResourcePath));
        return this;
    }

    public ContentUpgrade doMovePropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        LOG.debug("doMoveProperty: {} to {}", (Object)name, (Object)relativeResourcePath);
        this.actions.add(new MovePropertyToRelativePath(name, newName, this.context.getResolver(), relativeResourcePath));
        return this;
    }

    public ContentUpgrade doAddValuesToMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        LOG.debug("doAddToMultiValueProperty: {} + {}", (Object)name, (Object)Arrays.toString(values));
        this.actions.add(new AddMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doRemoveValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        LOG.debug("doRemoveValuesFromMultiValueProperty: {} - {}", (Object)name, (Object)Arrays.toString(values));
        this.actions.add(new RemoveMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doReplaceValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] oldValues, @Nonnull String[] newValues) {
        LOG.debug("doReplaceValuesOfMultiValueProperty: {} - {}", (Object)name, (Object)(Arrays.toString(oldValues) + " + " + Arrays.toString(newValues)));
        this.actions.add(new ReplaceMultiValues(name, oldValues, newValues));
        return this;
    }

    public ContentUpgrade doRename(String newName) {
        LOG.debug("doRename to {}", (Object)newName);
        this.actions.add(new RenameResource(this.context.getResolver(), newName));
        return this;
    }

    public ContentUpgrade doCopyResourceToRelativePath(@Nonnull String relativePath) {
        LOG.debug("doCopyResource to {}", (Object)relativePath);
        this.actions.add(new CopyResourceToRelativePath(relativePath, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doMoveResourceToRelativePath(@Nonnull String relativePath) {
        LOG.debug("doMoveResource to {}", (Object)relativePath);
        this.actions.add(new MoveResourceToRelativePath(relativePath, this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doDeleteResource() {
        LOG.debug("doDeleteResource");
        this.actions.add(new DeleteResource(this.context.getResolver()));
        return this;
    }

    public ContentUpgrade doCustomResourceBasedAction(CustomResourceAction action) {
        LOG.debug("doCustomResourceBasedAction");
        this.actions.add(new CustomAction(action));
        return this;
    }

    public ContentUpgrade doActivateContainingPage() {
        LOG.debug("doActivateContainingPage");
        this.actions.add(new ReplicatePageAction(true, this.context));
        return this;
    }

    public ContentUpgrade doDeactivateContainingPage() {
        LOG.debug("doDeactivateContainingPage");
        this.actions.add(new ReplicatePageAction(false, this.context));
        return this;
    }

    public ContentUpgrade doDeleteContainingPage() {
        LOG.debug("doDeleteContainingPage");
        this.actions.add(new DeletePageAction(this.context));
        return this;
    }

    public ContentUpgrade doAddTagsToContainingPage(String ... tags) {
        LOG.debug("doAddTagsToContainingPage");
        this.actions.add(new AddPageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doSetTagsForContainingPage(String ... tags) {
        LOG.debug("doSetTagsForContainingPage");
        this.actions.add(new SetPageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doRemoveTagsFromContainingPage(String ... tags) {
        LOG.debug("doRemoveTagsFromContainingPage");
        this.actions.add(new RemovePageTagsAction(this.context, tags));
        return this;
    }

    public ContentUpgrade doCheckPageRendering() {
        return this.doCheckPageRendering(200);
    }

    public ContentUpgrade doCheckPageRendering(int code) {
        this.actions.add(new RenderPageAction(this.context, code, null, null));
        return this;
    }

    public ContentUpgrade doCheckPageRendering(String textPresent) {
        return this.doCheckPageRendering(textPresent, null);
    }

    public ContentUpgrade doCheckPageRendering(String textPresent, String textNotPresent) {
        this.actions.add(new RenderPageAction(this.context, 200, textPresent, textNotPresent));
        return this;
    }

    public ContentUpgrade printPath() {
        LOG.debug("printPath");
        this.actions.add(new PrintPath());
        return this;
    }

    public ContentUpgrade printProperty(@Nonnull String property) {
        LOG.debug("printProperty {}", (Object)property);
        this.actions.add(new PrintProperty(property));
        return this;
    }

    public ContentUpgrade printJson() {
        LOG.debug("printJson");
        this.actions.add(new PrintJson());
        return this;
    }

    public StringBuffer run() throws PersistenceException, AecuException {
        LOG.debug("apply content upgrade");
        return this.run(false);
    }

    public StringBuffer dryRun() throws PersistenceException, AecuException {
        LOG.debug("apply content upgrade dry");
        return this.run(true);
    }

    public StringBuffer run(boolean dryRun) throws PersistenceException, AecuException {
        this.context.setDryRun(dryRun);
        StringBuffer stringBuffer = new StringBuffer("Running content upgrade " + (dryRun ? "DRY" : "") + "...\n");
        for (TraversData traversal : this.traversals) {
            traversal.traverse(this.context, this.filter, this.actions, stringBuffer, dryRun);
        }
        return stringBuffer;
    }
}

