/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.servlets;

import com.google.gson.JsonObject;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.servlets.BaseServlet;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.paths=/bin/public/valtech/aecu/execute", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class ExecutionServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    protected static final String ERROR_MESSAGE_MANDATORY = "ExecutionServlet :: Make sure your are sending the correct parameters.";
    @Reference
    AecuService aecuService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.setNoCache((HttpServletResponse)response);
        String historyEntryAction = request.getParameter("historyEntryAction");
        String aecuScriptPath = request.getParameter("aecuScriptPath");
        String skipExecution = request.getParameter("skipExecution");
        boolean skip = "true".equals(skipExecution);
        if (!this.validateParameter(aecuScriptPath) || !this.validateParameter(historyEntryAction)) {
            this.writeResult(response, ERROR_MESSAGE_MANDATORY);
            return;
        }
        try {
            HistoryEntry historyEntry = this.getHistoryEntry(request, response, historyEntryAction);
            ExecutionResult executionResult = skip ? new ExecutionResult(ExecutionState.SKIPPED, null, null, null, null, aecuScriptPath) : this.aecuService.execute(aecuScriptPath);
            this.aecuService.storeExecutionInHistory(historyEntry, executionResult);
            this.finishHistoryEntry(historyEntry, historyEntryAction);
            this.writeResult(response, this.prepareJson(executionResult, historyEntry.getRepositoryPath()));
        }
        catch (AecuException e) {
            this.sendInternalServerError(response);
        }
    }

    protected HistoryEntry getHistoryEntry(SlingHttpServletRequest request, SlingHttpServletResponse response, String historyEntryAction) throws AecuException, IOException {
        HistoryEntry historyEntry;
        switch (historyEntryAction.toLowerCase()) {
            case "use": 
            case "close": {
                String historyEntryPath = request.getParameter("historyEntryPath");
                if (!this.validateParameter(historyEntryPath)) {
                    this.writeResult(response, ERROR_MESSAGE_MANDATORY);
                    return null;
                }
                ResourceResolver resolver = request.getResourceResolver();
                HistoryUtil historyUtil = new HistoryUtil();
                historyEntry = historyUtil.readHistoryEntry(resolver.getResource(historyEntryPath));
                break;
            }
            default: {
                historyEntry = this.aecuService.createHistoryEntry();
            }
        }
        return historyEntry;
    }

    protected HistoryEntry finishHistoryEntry(HistoryEntry historyEntry, String historyEntryAction) throws AecuException {
        switch (historyEntryAction.toLowerCase()) {
            case "single": 
            case "close": {
                this.aecuService.finishHistoryEntry(historyEntry);
            }
        }
        return historyEntry;
    }

    protected String prepareJson(ExecutionResult executionResult, String historyEntryPath) {
        JsonObject json = new JsonObject();
        json.addProperty("state", executionResult.getState().name());
        json.addProperty("historyEntryPath", historyEntryPath);
        ExecutionResult fallbackExecutionResult = executionResult.getFallbackResult();
        if (fallbackExecutionResult != null) {
            json.addProperty("fallbackState", fallbackExecutionResult.getState().name());
        }
        return json.toString();
    }
}

