/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.service;

import com.icfolson.aem.groovy.console.GroovyConsoleService;
import com.icfolson.aem.groovy.console.response.RunScriptResponse;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.service.GroovyConsoleRequest;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AecuService.class})
public class AecuServiceImpl
implements AecuService {
    @Reference
    private ServiceResourceResolverService resolverService;
    @Reference
    private SlingSettingsService slingSettings;
    @Reference
    private GroovyConsoleService groovyConsoleService;

    public String getVersion() {
        return FrameworkUtil.getBundle(AecuServiceImpl.class).getVersion().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getFiles(String path) throws AecuException {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            List<String> list = this.findCandidates(resolver, path);
            return list;
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
    }

    private List<String> findCandidates(ResourceResolver resolver, String path) throws AecuException {
        if (path == null) {
            throw new AecuException("Path is null");
        }
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new AecuException("Path is invalid");
        }
        ArrayList<String> candidates = new ArrayList<String>();
        if (this.isFolder(resource) && this.matchesRunmodes(resource.getName())) {
            ArrayList<String> childNames = new ArrayList<String>();
            for (Resource child : resource.getChildren()) {
                childNames.add(child.getName());
            }
            childNames.sort(null);
            for (String childName : childNames) {
                candidates.addAll(this.findCandidates(resolver, resource.getChild(childName).getPath()));
            }
        } else if (this.isValidScriptName(resource.getName())) {
            candidates.add(path);
        }
        return candidates;
    }

    private boolean isFolder(Resource resource) {
        String type = (String)resource.getValueMap().get("jcr:primaryType", String.class);
        return "sling:Folder".equals(type) || "sling:OrderedFolder".equals(type) || "nt:folder".equals(type);
    }

    public boolean matchesRunmodes(String name) {
        String[] combinations;
        if (!name.contains(".")) {
            return true;
        }
        Set runModes = this.slingSettings.getRunModes();
        String runModeString = name.substring(name.indexOf(".") + 1);
        for (String combination : combinations = runModeString.split(";")) {
            String[] modes = combination.split("\\.");
            if (!runModes.containsAll(Arrays.asList(modes))) continue;
            return true;
        }
        return false;
    }

    public boolean isValidScriptName(String name) {
        if (!name.endsWith(".groovy")) {
            return false;
        }
        return !name.contains(".fallback.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecutionResult execute(String path) throws AecuException {
        try (ResourceResolver resolver = this.resolverService.getContentMigratorResourceResolver();){
            ExecutionResult result;
            Resource resource = resolver.getResource(path);
            if (resource == null) {
                throw new AecuException("Path is invalid");
            }
            if (!this.isValidScriptName(resource.getName())) {
                throw new AecuException("Invalid script name");
            }
            ExecutionResult executionResult = result = this.executeScript(resolver, path);
            return executionResult;
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
    }

    private ExecutionResult executeScript(ResourceResolver resolver, String path) {
        GroovyConsoleRequest request = new GroovyConsoleRequest(resolver);
        RunScriptResponse response = this.groovyConsoleService.runScript((SlingHttpServletRequest)request, path);
        boolean success = StringUtils.isBlank((CharSequence)response.getExceptionStackTrace());
        String result = response.getResult();
        ExecutionResult fallbackResult = null;
        if (!success && this.getFallbackScript(resolver, path) != null) {
            fallbackResult = this.executeScript(resolver, this.getFallbackScript(resolver, path));
        }
        ExecutionState state = success ? ExecutionState.SUCCESS : ExecutionState.FAILED;
        return new ExecutionResult(state, response.getRunningTime(), result, response.getOutput() + response.getExceptionStackTrace(), fallbackResult, path);
    }

    protected String getFallbackScript(ResourceResolver resolver, String path) {
        String name = path.substring(path.lastIndexOf("/") + 1);
        if (name.contains(".fallback.")) {
            return null;
        }
        String baseName = name.substring(0, name.indexOf("."));
        String fallbackPath = path.substring(0, path.lastIndexOf("/") + 1) + baseName + ".fallback.groovy";
        if (resolver.getResource(fallbackPath) != null) {
            return fallbackPath;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryEntry createHistoryEntry() throws AecuException {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            HistoryUtil historyUtil = new HistoryUtil();
            HistoryEntry entry = historyUtil.createHistoryEntry(resolver);
            resolver.commit();
            HistoryEntry historyEntry = entry;
            return historyEntry;
        }
        catch (PersistenceException e) {
            throw new AecuException("Unable to create history", (Throwable)e);
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryEntry finishHistoryEntry(HistoryEntry history) throws AecuException {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            HistoryUtil historyUtil = new HistoryUtil();
            historyUtil.finishHistoryEntry(history, resolver);
            resolver.commit();
            HistoryEntry historyEntry = history;
            return historyEntry;
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
        catch (PersistenceException e) {
            throw new AecuException("Unable to finish history " + history.getRepositoryPath(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryEntry storeExecutionInHistory(HistoryEntry history, ExecutionResult result) throws AecuException {
        if (history == null) throw new AecuException("Invalid history entry.");
        if (!HistoryEntry.STATE.RUNNING.equals((Object)history.getState())) {
            throw new AecuException("Invalid history entry.");
        }
        history.getSingleResults().add(result);
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            HistoryUtil historyUtil = new HistoryUtil();
            historyUtil.storeExecutionInHistory(history, result, resolver);
            resolver.commit();
            HistoryEntry historyEntry = history;
            return historyEntry;
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
        catch (PersistenceException e) {
            throw new AecuException("Unable to add history entry " + history.getRepositoryPath(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<HistoryEntry> getHistory(int startIndex, int count) throws AecuException {
        try (ResourceResolver resolver = this.resolverService.getServiceResourceResolver();){
            HistoryUtil historyUtil = new HistoryUtil();
            List<HistoryEntry> list = historyUtil.getHistory(startIndex, count, resolver);
            return list;
        }
        catch (LoginException e) {
            throw new AecuException("Unable to get service resource resolver", (Throwable)e);
        }
    }
}

