/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForResources
implements TraversData {
    private String[] paths;

    public ForResources(@Nonnull String[] paths) {
        this.paths = paths;
    }

    @Override
    public void traverse(@Nonnull ResourceResolver resourceResolver, FilterBy filter, @Nonnull List<Action> actions, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        for (String path : this.paths) {
            if (path == null) continue;
            Resource resource = resourceResolver.getResource(path);
            if (resource != null) {
                if (filter != null && !filter.filter(resource)) continue;
                for (Action action : actions) {
                    stringBuffer.append(action.doAction(resource) + "\n");
                }
                continue;
            }
            stringBuffer.append("WARNING: resource does not exist " + path + "\n");
        }
        if (!dryRun) {
            resourceResolver.commit();
        }
    }
}

