/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForDescendantResourcesOf
implements TraversData {
    private String path;
    private boolean includeRootResource;

    public ForDescendantResourcesOf(@Nonnull String path, boolean includeRootResource) {
        this.path = path;
        this.includeRootResource = includeRootResource;
    }

    @Override
    public void traverse(@Nonnull ResourceResolver resourceResolver, FilterBy filter, @Nonnull List<Action> actions, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        Resource parentResource = resourceResolver.getResource(this.path);
        if (parentResource != null) {
            if (this.includeRootResource) {
                this.applyActionOnResource(parentResource, filter, actions, stringBuffer);
            }
            this.traverseChildResourcesRecursive(resourceResolver, parentResource, filter, actions, stringBuffer, dryRun);
        }
    }

    private void traverseChildResourcesRecursive(ResourceResolver resourceResolver, Resource resource, FilterBy filter, List<Action> actions, StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        if (resource != null && resource.hasChildren()) {
            Iterator childResources = resource.listChildren();
            while (childResources.hasNext()) {
                Resource child = (Resource)childResources.next();
                this.applyActionOnResource(child, filter, actions, stringBuffer);
                this.traverseChildResourcesRecursive(resourceResolver, child, filter, actions, stringBuffer, dryRun);
            }
            if (!dryRun) {
                resourceResolver.commit();
            }
        }
    }

    private void applyActionOnResource(@Nonnull Resource resource, FilterBy filter, List<Action> actions, StringBuffer stringBuffer) throws PersistenceException {
        if (filter == null || filter.filter(resource)) {
            for (Action action : actions) {
                stringBuffer.append(action.doAction(resource) + "\n");
            }
        }
    }
}

