/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.impl;

import de.valtech.aecu.api.groovy.console.bindings.ContentUpgrade;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByHasProperty;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByMultiValuePropContains;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeName;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByNodeNameRegex;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperties;
import de.valtech.aecu.api.groovy.console.bindings.filters.FilterByProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.PrintPath;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.AddMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.RemoveMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.multivalue.ReplaceMultiValues;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.CopyPropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.DeleteProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.MovePropertyToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.RenameProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.properties.SetProperty;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.CopyResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.DeleteResource;
import de.valtech.aecu.core.groovy.console.bindings.actions.resource.MoveResourceToRelativePath;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForChildResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForDescendantResourcesOf;
import de.valtech.aecu.core.groovy.console.bindings.traversers.ForResources;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.scribe.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentUpgradeImpl
implements ContentUpgrade {
    private static Logger LOG = LoggerFactory.getLogger(ContentUpgrade.class);
    private ResourceResolver resourceResolver = null;
    private List<TraversData> traversals = new ArrayList<TraversData>();
    private FilterBy filter = null;
    private List<Action> actions = new ArrayList<Action>();

    public ContentUpgradeImpl(@Nonnull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public ContentUpgrade forResources(@Nonnull String[] paths) {
        LOG.debug("forResources: {}", (Object)paths.toString());
        this.traversals.add(new ForResources(paths));
        return this;
    }

    public ContentUpgrade forChildResourcesOf(@Nonnull String path) {
        LOG.debug("forChildResourcesOf: {}", (Object)path);
        this.traversals.add(new ForChildResourcesOf(path));
        return this;
    }

    public ContentUpgrade forDescendantResourcesOf(@Nonnull String path) {
        LOG.debug("forDescendantResourcesOf: {}", (Object)path);
        this.traversals.add(new ForDescendantResourcesOf(path, false));
        return this;
    }

    public ContentUpgrade forResourcesInSubtree(@Nonnull String path) {
        LOG.debug("forResourcesInSubtree: {}", (Object)path);
        this.traversals.add(new ForDescendantResourcesOf(path, true));
        return this;
    }

    public ContentUpgrade filterByProperties(@Nonnull Map<String, Object> conditionProperties) {
        LOG.debug("filterByProperties: {}", (Object)MapUtils.toString(conditionProperties));
        this.filter = new FilterByProperties(conditionProperties);
        return this;
    }

    public ContentUpgrade filterByProperty(@Nonnull String name, Object value) {
        LOG.debug("filterByProperty: {} {}", (Object)name, value);
        this.filter = new FilterByProperty(name, value);
        return this;
    }

    public ContentUpgrade filterByHasProperty(@Nonnull String name) {
        LOG.debug("filterByHasProperty: {} {}", (Object)name);
        this.filter = new FilterByHasProperty(name);
        return this;
    }

    public ContentUpgrade filterByMultiValuePropContains(@Nonnull String name, @Nonnull Object[] conditionValues) {
        LOG.debug("filterByMultiValuePropContains {} : {}", (Object)name, (Object)Arrays.toString(conditionValues));
        this.filter = new FilterByMultiValuePropContains(name, conditionValues);
        return this;
    }

    public ContentUpgrade filterByNodeName(@Nonnull String nodeName) {
        LOG.debug("filterByNodeName: {}", (Object)nodeName);
        this.filter = new FilterByNodeName(nodeName);
        return this;
    }

    public ContentUpgrade filterByNodeNameRegex(@Nonnull String regex) {
        LOG.debug("filterByNodeNameRegex: {}", (Object)regex);
        this.filter = new FilterByNodeNameRegex(regex);
        return this;
    }

    public ContentUpgrade filterWith(@Nonnull FilterBy filter) {
        LOG.debug("filterWith: {}", (Object)filter);
        this.filter = filter;
        return this;
    }

    public ContentUpgrade doSetProperty(@Nonnull String name, Object value) {
        LOG.debug("doSetProperty: {} = {}", (Object)name, value);
        this.actions.add(new SetProperty(name, value));
        return this;
    }

    public ContentUpgrade doDeleteProperty(@Nonnull String name) {
        LOG.debug("doDeleteProperty: {}", (Object)name);
        this.actions.add(new DeleteProperty(name));
        return this;
    }

    public ContentUpgrade doRenameProperty(@Nonnull String oldName, @Nonnull String newName) {
        LOG.debug("doRenameProperty: {} to {}", (Object)oldName, (Object)newName);
        this.actions.add(new RenameProperty(oldName, newName));
        return this;
    }

    public ContentUpgrade doCopyPropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        LOG.debug("doCopyProperty: {} to {}", (Object)name, (Object)relativeResourcePath);
        this.actions.add(new CopyPropertyToRelativePath(name, newName, this.resourceResolver, relativeResourcePath));
        return this;
    }

    public ContentUpgrade doMovePropertyToRelativePath(@Nonnull String name, String newName, @Nonnull String relativeResourcePath) {
        LOG.debug("doMoveProperty: {} to {}", (Object)name, (Object)relativeResourcePath);
        this.actions.add(new MovePropertyToRelativePath(name, newName, this.resourceResolver, relativeResourcePath));
        return this;
    }

    public ContentUpgrade doAddValuesToMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        LOG.debug("doAddToMultiValueProperty: {} + {}", (Object)name, (Object)Arrays.toString(values));
        this.actions.add(new AddMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doRemoveValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] values) {
        LOG.debug("doRemoveValuesFromMultiValueProperty: {} - {}", (Object)name, (Object)Arrays.toString(values));
        this.actions.add(new RemoveMultiValues(name, values));
        return this;
    }

    public ContentUpgrade doReplaceValuesOfMultiValueProperty(@Nonnull String name, @Nonnull String[] oldValues, @Nonnull String[] newValues) {
        LOG.debug("doReplaceValuesOfMultiValueProperty: {} - {}", (Object)name, (Object)(Arrays.toString(oldValues) + " + " + Arrays.toString(newValues)));
        this.actions.add(new ReplaceMultiValues(name, oldValues, newValues));
        return this;
    }

    public ContentUpgrade doCopyResourceToRelativePath(@Nonnull String relativePath) {
        LOG.debug("doCopyResource to {}", (Object)relativePath);
        this.actions.add(new CopyResourceToRelativePath(relativePath, this.resourceResolver));
        return this;
    }

    public ContentUpgrade doMoveResourceToRelativePath(@Nonnull String relativePath) {
        LOG.debug("doMoveResource to {}", (Object)relativePath);
        this.actions.add(new MoveResourceToRelativePath(relativePath, this.resourceResolver));
        return this;
    }

    public ContentUpgrade doDeleteResource() {
        LOG.debug("doDeleteResource");
        this.actions.add(new DeleteResource(this.resourceResolver));
        return this;
    }

    public ContentUpgrade printPath() {
        LOG.debug("printPath");
        this.actions.add(new PrintPath());
        return this;
    }

    public StringBuffer run() throws PersistenceException {
        LOG.debug("apply content upgrade");
        return this.run(false);
    }

    public StringBuffer dryRun() throws PersistenceException {
        LOG.debug("apply content upgrade dry");
        return this.run(true);
    }

    public StringBuffer run(boolean dryRun) throws PersistenceException {
        StringBuffer stringBuffer = new StringBuffer("Running content upgrade " + (dryRun ? "DRY" : "") + "...\n");
        for (TraversData traversal : this.traversals) {
            traversal.traverse(this.resourceResolver, this.filter, this.actions, stringBuffer, dryRun);
        }
        return stringBuffer;
    }
}

