/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.servlets;

import com.google.gson.JsonObject;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.servlets.BaseServlet;
import de.valtech.aecu.service.AecuException;
import de.valtech.aecu.service.AecuService;
import de.valtech.aecu.service.ExecutionResult;
import de.valtech.aecu.service.HistoryEntry;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.paths=/bin/public/valtech/aecu/execute", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class ExecutionServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionServlet.class);
    protected static final String ERROR_MESSAGE_MANDATORY = "ExecutionServlet :: Make sure your are sending the correct parameters.";
    @Reference
    AecuService aecuService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.setNoCache((HttpServletResponse)response);
        String historyEntryAction = request.getParameter("historyEntryAction");
        String aecuScriptPath = request.getParameter("aecuScriptPath");
        if (!this.validateParameter(aecuScriptPath) || !this.validateParameter(historyEntryAction)) {
            this.writeResult(response, ERROR_MESSAGE_MANDATORY);
            return;
        }
        try {
            HistoryEntry historyEntry = this.getHistoryEntry(request, response, historyEntryAction);
            ExecutionResult executionResult = this.aecuService.execute(aecuScriptPath);
            this.aecuService.storeExecutionInHistory(historyEntry, executionResult);
            this.finishHistoryEntry(historyEntry, historyEntryAction);
            this.writeResult(response, this.prepareJson(executionResult.isSuccess(), historyEntry.getRepositoryPath()));
        }
        catch (AecuException e) {
            this.sendInternalServerError(response);
        }
    }

    protected HistoryEntry getHistoryEntry(SlingHttpServletRequest request, SlingHttpServletResponse response, String historyEntryAction) throws AecuException, IOException {
        HistoryEntry historyEntry;
        switch (historyEntryAction.toLowerCase()) {
            case "use": 
            case "close": {
                String historyEntryPath = request.getParameter("historyEntryPath");
                if (!this.validateParameter(historyEntryPath)) {
                    this.writeResult(response, ERROR_MESSAGE_MANDATORY);
                    return null;
                }
                ResourceResolver resolver = request.getResourceResolver();
                HistoryUtil historyUtil = new HistoryUtil();
                historyEntry = historyUtil.readHistoryEntry(resolver.getResource(historyEntryPath));
                break;
            }
            default: {
                historyEntry = this.aecuService.createHistoryEntry();
            }
        }
        return historyEntry;
    }

    protected HistoryEntry finishHistoryEntry(HistoryEntry historyEntry, String historyEntryAction) throws AecuException {
        switch (historyEntryAction.toLowerCase()) {
            case "single": 
            case "close": {
                this.aecuService.finishHistoryEntry(historyEntry);
            }
        }
        return historyEntry;
    }

    protected String prepareJson(boolean status, String historyEntryPath) {
        JsonObject json = new JsonObject();
        json.addProperty("success", Boolean.valueOf(status));
        json.addProperty("historyEntryPath", historyEntryPath);
        return json.toString();
    }
}

