/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.model.history;

import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.service.ExecutionResult;
import de.valtech.aecu.service.HistoryEntry;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class HistoryOverview {
    @SlingObject
    private SlingHttpServletRequest request;
    @SlingObject
    private ResourceResolver resolver;
    private HistoryEntry historyEntry;
    private final DateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

    @PostConstruct
    public void init() {
        RequestParameter entryParam = this.request.getRequestParameter("entry");
        if (entryParam == null) {
            return;
        }
        String path = entryParam.getString();
        Resource historyResource = this.resolver.getResource(path);
        if (historyResource == null) {
            return;
        }
        HistoryUtil historyUtil = new HistoryUtil();
        this.historyEntry = historyUtil.readHistoryEntry(historyResource);
    }

    public HistoryEntry getHistory() {
        return this.historyEntry;
    }

    public String getStart() {
        if (this.historyEntry == null || this.historyEntry.getStart() == null) {
            return "";
        }
        return this.format.format(this.historyEntry.getStart());
    }

    public String getEnd() {
        if (this.historyEntry == null || this.historyEntry.getEnd() == null) {
            return "";
        }
        return this.format.format(this.historyEntry.getEnd());
    }

    public String getDuration() {
        Duration duration = Duration.between(this.historyEntry.getStart().toInstant(), this.historyEntry.getEnd().toInstant());
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            return duration.getSeconds() + "s";
        }
        return duration.getNano() / 1000000 + "ms";
    }

    public Pair<String, String> getPercentages() {
        int countAll = this.historyEntry.getSingleResults().size();
        if (countAll == 0) {
            return Pair.of((Object)"0", (Object)"0");
        }
        double countOk = 0.0;
        double countFailed = 0.0;
        for (ExecutionResult result : this.historyEntry.getSingleResults()) {
            if (result.isSuccess()) {
                countOk += 1.0;
                continue;
            }
            countFailed += 1.0;
        }
        BigDecimal percentageOk = new BigDecimal(countOk / (double)countAll * 100.0);
        BigDecimal percentageFailed = new BigDecimal(countFailed / (double)countAll * 100.0);
        String valueOk = percentageOk.round(new MathContext(2)).toPlainString();
        String valueFailed = percentageFailed.round(new MathContext(2)).toPlainString();
        return Pair.of((Object)valueOk, (Object)valueFailed);
    }
}

