/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.installhook;

import de.valtech.aecu.service.AecuException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.value.DateValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookExecutionHistory {
    private static final Logger LOG = LoggerFactory.getLogger(HookExecutionHistory.class);
    private static final String HISTORY_BASE_PATH = "/var/aecu-installhook";
    private static final String PN_EXECUTED = "executed";
    private final Node hookHistory;

    public HookExecutionHistory(Session session, String groovyScriptPath) throws AecuException {
        try {
            this.hookHistory = JcrUtils.getOrCreateByPath((String)(HISTORY_BASE_PATH + groovyScriptPath), (boolean)false, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)true);
        }
        catch (RepositoryException e) {
            throw new AecuException("Error getting or creating node at /var/aecu-installhook" + groovyScriptPath, (Throwable)e);
        }
    }

    public boolean hasBeenExecutedBefore() {
        boolean hasBeenExecuted = false;
        try {
            hasBeenExecuted = this.hookHistory.hasProperty(PN_EXECUTED);
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return hasBeenExecuted;
    }

    public void setExecuted() throws AecuException {
        try {
            this.hookHistory.setProperty(PN_EXECUTED, (Value)new DateValue(Calendar.getInstance()));
            this.hookHistory.getSession().save();
        }
        catch (RepositoryException e) {
            throw new AecuException("Could not set property executed", (Throwable)e);
        }
    }
}

