/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.healthcheck;

import de.valtech.aecu.service.AecuException;
import de.valtech.aecu.service.AecuService;
import de.valtech.aecu.service.HistoryEntry;
import java.util.List;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthCheck.class}, property={"hc.tags=aecu", "hc.name=AECU Last Run", "hc.mbean.name=aecuLastRunHCmBean"})
public class LastRunHealthCheck
implements HealthCheck {
    @Reference
    private AecuService aecuService;

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        try {
            List history = this.aecuService.getHistory(0, 1);
            if (history.isEmpty()) {
                resultLog.info("No runs found", new Object[0]);
            } else {
                HistoryEntry entry = (HistoryEntry)history.get(0);
                switch (entry.getResult()) {
                    case FAILURE: {
                        resultLog.critical("Last execution failed", new Object[0]);
                        break;
                    }
                    case SUCCESS: {
                        resultLog.info("Last run was successful", new Object[0]);
                        break;
                    }
                    case UNKNOWN: {
                        resultLog.warn("Last execution is still running", new Object[0]);
                    }
                }
            }
        }
        catch (AecuException e) {
            resultLog.critical(e.getMessage(), new Object[0]);
        }
        return new Result((ResultLog)resultLog);
    }
}

