/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForDescendantResourcesOf
implements TraversData {
    private String path;

    public ForDescendantResourcesOf(@Nonnull String path) {
        this.path = path;
    }

    @Override
    public void traverse(@Nonnull ResourceResolver resourceResolver, FilterBy filter, @Nonnull Action action, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        Resource parentResource = resourceResolver.getResource(this.path);
        if (parentResource != null) {
            this.traverseChildResourcesRecursive(resourceResolver, parentResource, filter, action, stringBuffer, dryRun);
        }
    }

    private void traverseChildResourcesRecursive(ResourceResolver resourceResolver, Resource resource, FilterBy filter, Action action, StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        if (resource != null && resource.hasChildren()) {
            Iterator childResources = resource.listChildren();
            while (childResources.hasNext()) {
                Resource child = (Resource)childResources.next();
                if (filter == null || filter.filter(child)) {
                    stringBuffer.append(action.doAction(child) + "\n");
                }
                this.traverseChildResourcesRecursive(resourceResolver, child, filter, action, stringBuffer, dryRun);
            }
            if (!dryRun) {
                resourceResolver.commit();
            }
        }
    }
}

