/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.traversers;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.filters.FilterBy;
import de.valtech.aecu.core.groovy.console.bindings.traversers.TraversData;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ForChildResourcesOf
implements TraversData {
    private String path;

    public ForChildResourcesOf(@Nonnull String path) {
        this.path = path;
    }

    @Override
    public void traverse(@Nonnull ResourceResolver resourceResolver, FilterBy filter, @Nonnull Action action, @Nonnull StringBuffer stringBuffer, boolean dryRun) throws PersistenceException {
        Resource parentResource = resourceResolver.getResource(this.path);
        if (parentResource != null) {
            Iterator resourceIterator = resourceResolver.listChildren(parentResource);
            while (resourceIterator.hasNext()) {
                Resource resource = (Resource)resourceIterator.next();
                if (filter != null && !filter.filter(resource)) continue;
                stringBuffer.append(action.doAction(resource) + "\n");
            }
            if (!dryRun) {
                resourceResolver.commit();
            }
        }
    }
}

