/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.properties;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MovePropertyToRelativePath
implements Action {
    private String relativeResourcePath;
    private String name;
    private String newName;
    private ResourceResolver resourceResolver;

    public MovePropertyToRelativePath(@Nonnull String name, String newName, @Nonnull ResourceResolver resourceResolver, @Nonnull String relativeResourcePath) {
        this.name = name;
        this.newName = newName;
        this.resourceResolver = resourceResolver;
        this.relativeResourcePath = relativeResourcePath;
    }

    @Override
    public String doAction(@Nonnull Resource resource) {
        ModifiableValueMap sourceProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        Resource targetResource = this.resourceResolver.getResource(resource, this.relativeResourcePath);
        ModifiableValueMap targetProperties = (ModifiableValueMap)targetResource.adaptTo(ModifiableValueMap.class);
        Object propValue = sourceProperties.get((Object)this.name);
        String key = this.newName != null ? this.newName : this.name;
        targetProperties.put((Object)key, propValue);
        sourceProperties.remove((Object)this.name);
        return "Moving property " + this.name + " from " + resource.getPath() + " to resource " + targetResource.getPath() + " as " + key;
    }
}

