/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.properties;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

public class CopyPropertyToRelativePath
implements Action {
    private String relativeResourcePath;
    private String name;
    private String newName;
    private ResourceResolver resourceResolver;

    public CopyPropertyToRelativePath(@Nonnull String name, String newName, @Nonnull ResourceResolver resourceResolver, @Nonnull String relativeResourcePath) {
        this.name = name;
        this.newName = newName;
        this.resourceResolver = resourceResolver;
        this.relativeResourcePath = relativeResourcePath;
    }

    @Override
    public String doAction(@Nonnull Resource resource) {
        ValueMap sourceProperties = (ValueMap)resource.adaptTo(ValueMap.class);
        Resource destinationResource = this.resourceResolver.getResource(resource, this.relativeResourcePath);
        ModifiableValueMap destinationProperties = (ModifiableValueMap)destinationResource.adaptTo(ModifiableValueMap.class);
        Object propValue = sourceProperties.get((Object)this.name);
        String key = this.newName != null ? this.newName : this.name;
        destinationProperties.put((Object)key, propValue);
        return "Coping property " + this.name + " from " + resource.getPath() + " to resource " + destinationResource.getPath() + " as " + key;
    }
}

