/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.multivalue;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class AddMultiValues
implements Action {
    private String name;
    private String[] values;

    public AddMultiValues(@Nonnull String name, @Nonnull String[] values) {
        this.name = name;
        this.values = Arrays.stream(values).filter(f -> f != null).collect(Collectors.toList()).toArray(new String[0]);
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (properties != null) {
            Object[] currentValues = (String[])properties.get(this.name, String[].class);
            ArrayList valuesList = new ArrayList();
            if (currentValues != null && currentValues.length > 0) {
                Collections.addAll(valuesList, currentValues);
            }
            Collections.addAll(valuesList, this.values);
            properties.put((Object)this.name, (Object)valuesList.toArray(new String[0]));
            return "Adding values " + Arrays.toString(this.values) + " to multi-value property " + this.name + ": " + Arrays.toString(currentValues) + " results in " + valuesList + " for resource " + resource.getPath();
        }
        return "WARNING: could not get ModifiableValueMap for resource " + resource.getPath();
    }
}

