/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.service;

import be.orbinson.aem.groovy.console.api.context.ScriptContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AecuScriptContext
implements ScriptContext {
    private static final Logger LOG = LoggerFactory.getLogger(AecuScriptContext.class);
    private String script;
    private ResourceResolver resolver;
    private String data;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public AecuScriptContext(String script, ResourceResolver resolver, String data) {
        this.script = script;
        this.resolver = resolver;
        this.data = data;
    }

    public AecuScriptContext(String script, ResourceResolver resolver) {
        this(script, resolver, null);
    }

    public String getData() {
        return this.data;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.out;
    }

    public PrintStream getPrintStream() {
        try {
            return new PrintStream((OutputStream)this.out, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to create print stream", (Throwable)e);
            return null;
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public String getScript() {
        return this.script;
    }

    public String getUserId() {
        return this.resolver.getUserID();
    }
}

