/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class DeleteResource
implements Action {
    private ResourceResolver resourceResolver;
    private String[] children;

    public DeleteResource(@Nonnull ResourceResolver resourceResolver, String ... children) {
        this.resourceResolver = resourceResolver;
        this.children = (String[])children.clone();
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ArrayList<String> deletedResources = new ArrayList<String>();
        ArrayList<String> nonExistingResources = new ArrayList<String>();
        String resourcePath = resource.getPath();
        if (0 == this.children.length) {
            this.resourceResolver.delete(resource);
            return "Deleted resource " + resourcePath;
        }
        for (String child : this.children) {
            Resource childResource = this.resourceResolver.getResource(resource, child);
            String childResourcePath = resourcePath + "/" + child;
            if (null != childResource) {
                this.resourceResolver.delete(childResource);
                deletedResources.add(childResourcePath);
                continue;
            }
            nonExistingResources.add(childResourcePath);
        }
        String message = "Deleted child resource(s) " + Arrays.toString(deletedResources.toArray()) + ".";
        if (!nonExistingResources.isEmpty()) {
            message = message + " Child resource(s) " + Arrays.toString(nonExistingResources.toArray()) + " were not found.";
        }
        return message;
    }
}

