/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.util.MixinUtil;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class RemoveMixin
implements Action {
    private final String mixinName;

    public RemoveMixin(String mixinName) {
        this.mixinName = mixinName;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        if (StringUtils.isBlank((CharSequence)this.mixinName)) {
            return "WARNING: mixin name is empty";
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return "WARNING: could not get node for " + resource.getPath();
        }
        try {
            if (MixinUtil.hasMixin(node, this.mixinName)) {
                node.removeMixin(this.mixinName);
                return String.format("Removing mixin %s from %s", this.mixinName, resource.getPath());
            }
            return String.format("No mixin %s present on %s", this.mixinName, resource.getPath());
        }
        catch (NoSuchNodeTypeException nsnte) {
            return "WARNING: non-existing mixin: " + this.mixinName;
        }
        catch (RepositoryException re) {
            throw new PersistenceException("Problem when removing mixin from node", (Throwable)re);
        }
    }
}

