/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.security;

import de.valtech.aecu.core.security.AccessValidationServiceConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AccessValidationService.class})
@Designate(ocd=AccessValidationServiceConfiguration.class)
public class AccessValidationService {
    protected static final String ADMINISTRATORS = "administrators";
    private static final Logger LOG = LoggerFactory.getLogger(AccessValidationService.class);
    private AccessValidationServiceConfiguration config;

    @Activate
    public void activate(AccessValidationServiceConfiguration config) {
        this.config = config;
    }

    public boolean canReadHistory(SlingHttpServletRequest request) {
        return this.isAdminOrInAllowedList(request, this.config.readers());
    }

    public boolean canExecute(SlingHttpServletRequest request) {
        return this.isAdminOrInAllowedList(request, this.config.executers());
    }

    private boolean isAdminOrInAllowedList(SlingHttpServletRequest request, String[] groups) {
        String userName = this.getUserName(request);
        if (this.isAdmin(userName)) {
            return true;
        }
        List<String> userGroups = this.getUserGroupNames(request);
        if (userGroups.contains(ADMINISTRATORS)) {
            return true;
        }
        if (groups == null) {
            return false;
        }
        for (String group : groups) {
            if (!userGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    private String getUserName(SlingHttpServletRequest request) {
        return request.getUserPrincipal().getName();
    }

    private List<String> getUserGroupNames(SlingHttpServletRequest request) {
        ArrayList<String> groupList = new ArrayList<String>();
        UserManager userManager = (UserManager)request.getResourceResolver().adaptTo(UserManager.class);
        try {
            Authorizable authorizable = userManager.getAuthorizable(request.getUserPrincipal());
            Iterator groupIt = authorizable.memberOf();
            while (groupIt.hasNext()) {
                groupList.add(((Group)groupIt.next()).getID());
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get groups", (Throwable)e);
        }
        return groupList;
    }

    private boolean isAdmin(String userName) {
        return "admin".equals(userName);
    }
}

