/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.omnisearch;

import com.adobe.granite.omnisearch.api.suggestion.PredicateSuggestion;
import com.adobe.granite.omnisearch.spi.core.OmniSearchHandler;
import com.day.cq.i18n.I18n;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HistorySearchHandler
implements OmniSearchHandler {
    protected static final String CONFIG_PATH = "/apps/valtech/aecu/omnisearch/content/metadata/aecuHistory";
    protected static final String ID = "aecuHistory";
    private static final Logger LOG = LoggerFactory.getLogger(HistorySearchHandler.class);
    @Reference
    private QueryBuilder queryBuilder;

    public String getID() {
        return ID;
    }

    public Resource getModuleConfig(ResourceResolver resourceResolver) {
        return resourceResolver.getResource(CONFIG_PATH);
    }

    public List<PredicateSuggestion> getPredicateSuggestions(ResourceResolver arg0, I18n arg1, String arg2) {
        return new ArrayList<PredicateSuggestion>();
    }

    public SearchResult getResults(ResourceResolver resolver, Map<String, Object> predicateParameters, long limit, long offset) {
        HashMap<String, Object> predicates = new HashMap<String, Object>(predicateParameters);
        predicates.put("path", "/var/aecu");
        PredicateGroup predicateGroup = PredicateGroup.create(predicates);
        com.day.cq.search.Query query = this.queryBuilder.createQuery(predicateGroup, (Session)resolver.adaptTo(Session.class));
        if (limit != 0L) {
            query.setHitsPerPage(limit);
        }
        if (offset != 0L) {
            query.setStart(offset);
        }
        return query.getResult();
    }

    public Query getSpellCheckQuery(ResourceResolver resourceResolver, String searchTerm) {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                return null;
            }
            String queryStr = "SELECT [rep:spellcheck()] FROM [nt:base] as s WHERE [jcr:path] = '/var/aecu' AND SPELLCHECK($searchTerm)";
            Query query = this.setupQuery(session, "SELECT [rep:spellcheck()] FROM [nt:base] as s WHERE [jcr:path] = '/var/aecu' AND SPELLCHECK($searchTerm)");
            ValueFactory valueFactory = session.getValueFactory();
            query.bindValue("searchTerm", valueFactory.createValue(searchTerm));
            return query;
        }
        catch (RepositoryException e) {
            LOG.error("Unable to create spell check query", (Throwable)e);
            return null;
        }
    }

    public Query getSuggestionQuery(ResourceResolver resourceResolver, String searchTerm) {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                return null;
            }
            String queryStr = "SELECT [rep:suggest()] FROM [dam:Asset] as s WHERE SUGGEST($searchTerm) AND ISDESCENDANTNODE([/var/aecu])";
            Query query = this.setupQuery(session, "SELECT [rep:suggest()] FROM [dam:Asset] as s WHERE SUGGEST($searchTerm) AND ISDESCENDANTNODE([/var/aecu])");
            ValueFactory valueFactory = session.getValueFactory();
            query.bindValue("searchTerm", valueFactory.createValue(searchTerm));
            return query;
        }
        catch (RepositoryException e) {
            LOG.error("Unable to create spell check query", (Throwable)e);
            return null;
        }
    }

    private Query setupQuery(Session session, String queryString) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return queryManager.createQuery(queryString, "JCR-SQL2");
    }
}

