/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.installhook;

import javax.annotation.Nonnull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class OsgiServiceProvider {
    private final BundleContext bundleContext;

    public OsgiServiceProvider(@Nonnull Class clazz) {
        Bundle currentBundle = FrameworkUtil.getBundle((Class)clazz);
        if (currentBundle == null) {
            throw new IllegalStateException("The class " + clazz + " was not loaded through a bundle classloader");
        }
        this.bundleContext = currentBundle.getBundleContext();
        if (this.bundleContext == null) {
            throw new IllegalStateException("Could not get bundle context for bundle " + currentBundle);
        }
    }

    @Nonnull
    <T> ServiceReference<T> getServiceReference(@Nonnull Class<T> clazz) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz);
        if (serviceReference == null) {
            throw new IllegalStateException("Could not retrieve service reference for class " + clazz);
        }
        return serviceReference;
    }

    @Nonnull
    <T> T getService(@Nonnull ServiceReference<T> serviceReference) {
        Object service = this.bundleContext.getService(serviceReference);
        if (service == null) {
            throw new IllegalStateException("Could not get the service for reference " + serviceReference + ", verify that the bundle was installed correctly!");
        }
        return (T)service;
    }

    boolean ungetService(@Nonnull ServiceReference<?> serviceReference) {
        return this.bundleContext.ungetService(serviceReference);
    }
}

