/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.installhook;

import de.valtech.aecu.api.service.AecuService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AecuTrackerListener
implements ProgressTrackerListener {
    private static final Logger LOG = LoggerFactory.getLogger(AecuTrackerListener.class);
    public static final String ALWAYS_SUFFIX = "always.groovy";
    private static final Set<String> ACTIONS = new HashSet<String>(Arrays.asList("A", "M", "U"));
    private static final String ACTION_DELETE = "D";
    private static final int VALID_ACTION_LENGTH = 1;
    private static final String LOG_PREFIX = "AECU InstallHook: ";
    private final ProgressTrackerListener originalListener;
    private final AecuService aecuService;
    private final Set<String> paths;

    public AecuTrackerListener(ProgressTrackerListener originalListener, AecuService aecuService) {
        this.originalListener = originalListener;
        this.aecuService = aecuService;
        this.paths = new HashSet<String>();
        if (originalListener == null) {
            this.logMessage("No progress tracker listener given.");
        } else {
            this.logMessage("Starting install hook...");
        }
    }

    @Nonnull
    public List<String> getModifiedOrAddedPaths() {
        return new ArrayList<String>(this.paths);
    }

    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        if (this.originalListener != null) {
            this.originalListener.onMessage(mode, action, path);
        }
        if (StringUtils.length((CharSequence)action) != 1) {
            return;
        }
        if (ACTION_DELETE.equals(action)) {
            return;
        }
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)ALWAYS_SUFFIX) && this.isValid(path)) {
            this.logMessage(String.format("Adding %s due to having 'always' in name.", path));
            this.paths.add(path);
            return;
        }
        if (!ACTIONS.contains(action) && this.isValid(path)) {
            LOG.debug(String.format("Skipping %s due to non matching action '%s'", path, action));
            return;
        }
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)"/jcr:content")) {
            path = StringUtils.substringBefore((String)path, (String)"/jcr:content");
        }
        if (!this.paths.contains(path) && this.isValid(path)) {
            this.logMessage(String.format("Found valid script path '%s'", path));
            this.paths.add(path);
        }
    }

    private boolean isValid(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && this.aecuService.isValidScriptName(path) && (path.startsWith("/var/groovyconsole/scripts/aecu") || path.startsWith("/conf/groovyconsole/scripts/aecu") || path.startsWith("/apps/aecu-scripts"));
    }

    public void onError(ProgressTrackerListener.Mode mode, String action, Exception e) {
        if (this.originalListener != null) {
            this.originalListener.onError(mode, action, e);
        }
    }

    public void logMessage(String message) {
        LOG.info(message);
        if (this.originalListener != null) {
            this.originalListener.onMessage(ProgressTrackerListener.Mode.TEXT, LOG_PREFIX + message, "");
        }
    }

    public void logError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        this.onError(ProgressTrackerListener.Mode.TEXT, LOG_PREFIX + message, e);
    }
}

