/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.impl;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.replication.Replicator;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.PageManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class BindingContext {
    private ResourceResolver resolver;
    private PageManager pageManager;
    private TagManager tagManager;
    private Replicator replicator;
    private boolean dryRun = true;
    private RequestResponseFactory requestResponseFactory;
    private SlingRequestProcessor slingRequestProcessor;

    public BindingContext(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public PageManager getPageManager() {
        if (this.pageManager != null) {
            return this.pageManager;
        }
        this.pageManager = (PageManager)this.resolver.adaptTo(PageManager.class);
        return this.pageManager;
    }

    public TagManager getTagManager() {
        if (this.tagManager != null) {
            return this.tagManager;
        }
        this.tagManager = (TagManager)this.resolver.adaptTo(TagManager.class);
        return this.tagManager;
    }

    public Replicator getReplicator() {
        if (this.replicator != null) {
            return this.replicator;
        }
        Bundle bundle = FrameworkUtil.getBundle(BindingContext.class);
        ServiceReference replicatorReference = bundle.getBundleContext().getServiceReference(Replicator.class);
        if (replicatorReference != null) {
            this.replicator = (Replicator)bundle.getBundleContext().getService(replicatorReference);
        }
        return this.replicator;
    }

    public RequestResponseFactory getRequestResponseFactory() {
        if (this.requestResponseFactory != null) {
            return this.requestResponseFactory;
        }
        Bundle bundle = FrameworkUtil.getBundle(BindingContext.class);
        ServiceReference requestResponseFactoryReference = bundle.getBundleContext().getServiceReference(RequestResponseFactory.class);
        if (requestResponseFactoryReference != null) {
            this.requestResponseFactory = (RequestResponseFactory)bundle.getBundleContext().getService(requestResponseFactoryReference);
        }
        return this.requestResponseFactory;
    }

    public SlingRequestProcessor getSlingRequestProcessor() {
        if (this.slingRequestProcessor != null) {
            return this.slingRequestProcessor;
        }
        Bundle bundle = FrameworkUtil.getBundle(BindingContext.class);
        ServiceReference slingRequestProcessorReference = bundle.getBundleContext().getServiceReference(SlingRequestProcessor.class);
        if (slingRequestProcessorReference != null) {
            this.slingRequestProcessor = (SlingRequestProcessor)bundle.getBundleContext().getService(slingRequestProcessorReference);
        }
        return this.slingRequestProcessor;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }
}

