/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class ReorderNode
implements Action {
    protected String nameOfNodeToMove;
    protected String newSuccessor;
    private BindingContext context;

    public ReorderNode(@Nonnull String nameOfNodeToMove, @Nullable String newSuccessor, @Nonnull BindingContext context) {
        this.nameOfNodeToMove = nameOfNodeToMove;
        this.newSuccessor = newSuccessor;
        this.context = context;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        Node node = (Node)resource.adaptTo(Node.class);
        try {
            if (null != node) {
                if (!this.context.isDryRun()) {
                    node.orderBefore(this.nameOfNodeToMove, this.newSuccessor);
                }
                return "Reordered " + this.nameOfNodeToMove + " on resource " + resource.getPath();
            }
        }
        catch (RepositoryException e) {
            throw new PersistenceException("ERROR: could not reorder " + this.nameOfNodeToMove + " on resource " + resource.getPath(), (Throwable)e);
        }
        return "WARNING: could not reorder " + this.nameOfNodeToMove;
    }
}

