/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.properties;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;

public class RenameProperty
implements Action {
    private String oldName;
    private String newName;
    private String subNodePath;

    public RenameProperty(@Nonnull String oldName, @Nonnull String newName, String subNodePath) {
        this.oldName = oldName;
        this.newName = newName;
        this.subNodePath = subNodePath;
    }

    @Override
    public String doAction(@Nonnull Resource resource) {
        Resource operatingResource = resource;
        if (this.subNodePath != null && (operatingResource = resource.getChild(this.subNodePath)) == null) {
            String finalPath = resource.getPath() + "/" + this.subNodePath;
            return "WARNING: Resource " + finalPath + " not found.";
        }
        ModifiableValueMap properties = (ModifiableValueMap)operatingResource.adaptTo(ModifiableValueMap.class);
        if (properties == null) {
            return "WARNING: could not get ModifiableValueMap for resource " + operatingResource.getPath();
        }
        if (!properties.containsKey((Object)this.oldName)) {
            return "WARNING: property " + this.oldName + " does not exist on " + operatingResource.getPath();
        }
        Object value = properties.remove((Object)this.oldName);
        properties.put((Object)this.newName, value);
        return "Renaming property " + this.oldName + " to " + this.newName + " for resource " + operatingResource.getPath();
    }
}

