/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.print;

import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintProperty
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(PrintProperty.class);
    private String propertyName;

    public PrintProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String doAction(@Nonnull Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        String output = this.propertyName + " = ";
        try {
            if (node.hasProperty(this.propertyName)) {
                Property prop = node.getProperty(this.propertyName);
                if (prop.isMultiple()) {
                    Value[] values = prop.getValues();
                    Object[] valuesAsStrings = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        valuesAsStrings[i] = values[i].getString();
                    }
                    output = output + Arrays.toString(valuesAsStrings);
                } else {
                    output = output + prop.getValue().getString();
                }
                return output;
            }
            return this.propertyName + " not defined";
        }
        catch (RepositoryException e) {
            LOG.debug("Cannot read value of [{}]. Reason [{}]", (Object)this.propertyName, (Object)e.getMessage());
            return "";
        }
    }
}

