/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class DeletePageAction
implements Action {
    private BindingContext context;

    public DeletePageAction(BindingContext context) {
        this.context = context;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        String successMessage = "Deleted page " + page.getPath();
        if (this.context.isDryRun()) {
            return successMessage;
        }
        try {
            this.context.getPageManager().delete(page, false);
        }
        catch (WCMException e) {
            throw new PersistenceException("Unable to delete " + page.getPath());
        }
        return successMessage;
    }
}

