/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights;

import de.valtech.aecu.api.groovy.console.bindings.accessrights.AccessRightValidator;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidateAccessRightsTable {
    private List<TableRow> rows = new ArrayList<TableRow>();
    private List<ErrorRow> errorRows = new ArrayList<ErrorRow>();
    private boolean hasErrors = false;

    public void add(AccessRightValidator validator, boolean simulate) {
        TableRow lastRow;
        ValidationResult result = validator.validate(simulate);
        String authorizable = validator.getGroupId();
        String path = validator.getResource().getPath();
        if (this.rows.isEmpty()) {
            this.rows.add(new TableRow(authorizable, path, null));
        }
        if (!authorizable.equals((lastRow = this.rows.get(this.rows.size() - 1)).authorizable) || !path.equals(lastRow.path)) {
            if (!authorizable.equals(lastRow.authorizable)) {
                this.rows.add(null);
            }
            lastRow = new TableRow(authorizable, path, this.rows.get(this.rows.size() - 1));
            this.rows.add(lastRow);
        }
        lastRow.addResult(validator.getLabel(), result);
        if (result.hasErrors()) {
            String errorMessage = result.getMessage();
            if (errorMessage == null) {
                errorMessage = "";
            }
            this.errorRows.add(new ErrorRow(authorizable, path, validator.getLabel() + ": " + errorMessage));
        }
    }

    public String getText() {
        AsciiTable table = new AsciiTable();
        CWC_LongestLine cwc = new CWC_LongestLine();
        table.getRenderer().setCWC((AT_ColumnWidthCalculator)cwc);
        table.getContext().getGrid().addCharacterMap(512, ' ', '\u2550', ' ', '\u2550', '\u2550', '\u2550', '\u2550', '\u2550', '\u2550', '\u2550', '\u2550', '\u2550');
        table.addRule();
        table.addRow(new Object[]{"Group", "Path", "Rights"});
        table.addRule();
        for (TableRow row : this.rows) {
            if (row == null) {
                table.addRule();
                continue;
            }
            table.addRow(new Object[]{row.getAuthorizable(), row.getPath(), row.getCheckResultsText()});
        }
        if (!this.errorRows.isEmpty()) {
            this.hasErrors = true;
            table.addStrongRule();
            AT_Row detailsRow = table.addRow(new Object[]{null, null, "Issue details"});
            detailsRow.setTextAlignment(TextAlignment.CENTER);
            table.addStrongRule();
            table.addRow(new Object[]{"Group", "Path", "Issue"});
            for (ErrorRow row : this.errorRows) {
                table.addRule();
                table.addRow(new Object[]{row.getGroup(), row.getPath(), row.getMessage()});
            }
        }
        table.addRule();
        return table.render();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private static class ErrorRow {
        private String group;
        private String path;
        private String message;

        public ErrorRow(String group, String path, String message) {
            this.group = group;
            this.path = path;
            this.message = message;
        }

        public String getGroup() {
            return this.group;
        }

        public String getPath() {
            return this.path;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class TableRow {
        private String authorizable;
        private String path;
        private List<String> checkLabelsOk = new ArrayList<String>();
        private List<String> checkLabelsWarning = new ArrayList<String>();
        private List<String> checkLabelsFail = new ArrayList<String>();
        private TableRow lastRow;

        public TableRow(String authorizable, String path, TableRow lastRow) {
            this.authorizable = authorizable;
            this.path = path;
            this.lastRow = lastRow;
        }

        public void addResult(String label, ValidationResult result) {
            if (result.isSuccessful()) {
                this.checkLabelsOk.add(label);
            } else if (result.hasWarnings()) {
                this.checkLabelsWarning.add(label);
            } else {
                this.checkLabelsFail.add(label);
            }
        }

        public String getCheckResultsText() {
            String labels;
            Collections.sort(this.checkLabelsOk);
            Collections.sort(this.checkLabelsFail);
            StringBuilder output = new StringBuilder();
            if (!this.checkLabelsFail.isEmpty()) {
                labels = String.join((CharSequence)", ", this.checkLabelsFail);
                output.append("FAIL: " + labels);
            }
            if (!this.checkLabelsFail.isEmpty() && !this.checkLabelsWarning.isEmpty()) {
                output.append("; ");
            }
            if (!this.checkLabelsWarning.isEmpty()) {
                labels = String.join((CharSequence)", ", this.checkLabelsWarning);
                output.append("WARNING: " + labels);
            }
            if (!(this.checkLabelsFail.isEmpty() && this.checkLabelsWarning.isEmpty() || this.checkLabelsOk.isEmpty())) {
                output.append("; ");
            }
            if (!this.checkLabelsOk.isEmpty()) {
                labels = String.join((CharSequence)", ", this.checkLabelsOk);
                output.append("OK: " + labels);
            }
            return output.toString();
        }

        public String getAuthorizable() {
            if (this.lastRow == null) {
                return this.authorizable;
            }
            if (this.lastRow.authorizable.equals(this.authorizable)) {
                return "";
            }
            return this.authorizable;
        }

        public String getPath() {
            return this.path;
        }
    }
}

