/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.page;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import de.valtech.aecu.api.groovy.console.bindings.accessrights.ValidationResult;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.AccessValidatorContext;
import de.valtech.aecu.core.groovy.console.bindings.accessrights.validators.resource.ReplicateAccessValidator;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatePageAccessValidator
extends ReplicateAccessValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatePageAccessValidator.class);
    private ReplicationActionType type;

    public ReplicatePageAccessValidator(Group group, Resource resource, AccessValidatorContext context, boolean checkAccessGranted, ReplicationActionType type) {
        super(group, resource, context, checkAccessGranted);
        this.type = type;
    }

    @Override
    public ValidationResult validate(boolean simulate) {
        ValidationResult resourceResult = super.validate(simulate);
        if (!resourceResult.isSuccessful()) {
            return resourceResult;
        }
        if (!this.pageExists()) {
            return new ValidationResult(false, true, "Page not found");
        }
        return this.canReplicatePageWithUser(simulate);
    }

    private boolean pageExists() {
        Page page = this.getContext().getAdminPageManager().getPage(this.getResource().getPath());
        return page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult canReplicatePageWithUser(boolean simulate) {
        AccessValidatorContext.TestUser testUser = this.getContext().getTestUserForGroup(this.group);
        if (testUser == null) {
            return new ValidationResult(true, false, "Unable to create test user");
        }
        PageManager userPageManager = (PageManager)testUser.getResolver().adaptTo(PageManager.class);
        Page page = userPageManager.getPage(this.getResource().getPath());
        if (page == null) {
            return new ValidationResult(this.getCheckAccessGranted(), false, "Cannot read page");
        }
        if (!simulate) {
            return new ValidationResult(!this.getCheckAccessGranted(), false, "Wrong permissions");
        }
        try {
            Session session = (Session)testUser.getResolver().adaptTo(Session.class);
            this.getContext().getReplicator().replicate(session, this.type, page.getPath());
        }
        catch (ReplicationException e) {
            LOG.error("Unable to perform replictaion", (Throwable)e);
            ValidationResult validationResult = new ValidationResult(this.getCheckAccessGranted(), false, e.getMessage());
            return validationResult;
        }
        finally {
            testUser.getResolver().revert();
            testUser.getResolver().refresh();
        }
        return new ValidationResult(!this.getCheckAccessGranted(), false, "Cannot replicate page");
    }

    @Override
    public String getLabel() {
        return this.getCheckAccessGranted() ? "Replicate Page" : "Cannot Replicate Page";
    }
}

