/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.model.history;

import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.ExecutionState;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.security.AccessValidationService;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class HistoryOverview {
    @SlingObject
    private SlingHttpServletRequest request;
    @SlingObject
    private ResourceResolver resolver;
    @OSGiService
    private HistoryUtil historyUtil;
    @OSGiService
    private AccessValidationService accessValidationService;
    private HistoryEntry historyEntry;
    private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @PostConstruct
    public void init() {
        if (!this.accessValidationService.canReadHistory(this.request)) {
            return;
        }
        RequestParameter entryParam = this.request.getRequestParameter("entry");
        if (entryParam == null) {
            return;
        }
        String path = entryParam.getString();
        Resource historyResource = this.resolver.getResource(path);
        if (historyResource == null) {
            return;
        }
        this.historyEntry = this.historyUtil.readHistoryEntry(historyResource);
    }

    public HistoryEntry getHistory() {
        return this.historyEntry;
    }

    public String getStart() {
        if (this.historyEntry == null || this.historyEntry.getStart() == null) {
            return "";
        }
        return this.format.format(this.historyEntry.getStart());
    }

    public String getEnd() {
        if (this.historyEntry == null || this.historyEntry.getEnd() == null) {
            return "";
        }
        return this.format.format(this.historyEntry.getEnd());
    }

    public String getDuration() {
        Duration duration = Duration.between(this.historyEntry.getStart().toInstant(), this.historyEntry.getEnd().toInstant());
        long seconds = duration.getSeconds();
        if (seconds > 0L) {
            return duration.getSeconds() + "s";
        }
        return duration.getNano() / 1000000 + "ms";
    }

    public DonutData getDonutData() {
        int countAll = this.historyEntry.getSingleResults().size();
        if (countAll == 0) {
            return new DonutData(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        double countOk = 0.0;
        double countFailed = 0.0;
        for (ExecutionResult result : this.historyEntry.getSingleResults()) {
            if (ExecutionState.SUCCESS.equals((Object)result.getState())) {
                countOk += 1.0;
                continue;
            }
            if (!ExecutionState.FAILED.equals((Object)result.getState())) continue;
            countFailed += 1.0;
        }
        BigDecimal percentageOk = BigDecimal.valueOf(countOk / (double)countAll * 100.0);
        BigDecimal percentageFailed = BigDecimal.valueOf(countFailed / (double)countAll * 100.0);
        return new DonutData(percentageOk, percentageFailed);
    }

    public static class DonutData {
        private BigDecimal percentageOk;
        private BigDecimal percentageFail;

        public DonutData(BigDecimal percentageOk, BigDecimal percentageFail) {
            this.percentageOk = percentageOk.round(new MathContext(2));
            this.percentageFail = percentageFail.round(new MathContext(2));
        }

        public String getOkLength() {
            return this.percentageOk.toPlainString();
        }

        public String getOkRemainder() {
            return new BigDecimal(100).subtract(this.percentageOk).toPlainString();
        }

        public String getFailedLength() {
            return this.percentageFail.add(this.percentageOk).toPlainString();
        }

        public String getFailedRemainder() {
            return new BigDecimal(100).subtract(this.percentageFail).subtract(this.percentageOk).toPlainString();
        }

        public String getPercentageOk() {
            return this.percentageOk.toPlainString();
        }
    }
}

