/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.jmx;

import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.installhook.HookExecutionHistory;
import de.valtech.aecu.core.jmx.AecuServiceMBean;
import de.valtech.aecu.core.serviceuser.ServiceResourceResolverService;
import java.util.List;
import javax.jcr.Session;
import javax.management.NotCompliantMBeanException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AecuServiceMBean.class}, immediate=true, property={"jmx.objectname=de.valtech:type=AECU", "pattern=/.*"})
public class AecuServiceMBeanImpl
extends AnnotatedStandardMBean
implements AecuServiceMBean {
    @Reference
    private AecuService aecuService;
    @Reference
    private ServiceResourceResolverService serviceResourceResolver;

    public AecuServiceMBeanImpl() throws NotCompliantMBeanException {
        super(AecuServiceMBean.class);
    }

    @Override
    public String getVersion() {
        return this.aecuService.getVersion();
    }

    @Override
    public List<String> getFiles(String path) throws AecuException {
        return this.aecuService.getFiles(path);
    }

    @Override
    public String execute(String path) throws AecuException {
        HistoryEntry history = this.aecuService.createHistoryEntry();
        List files = this.aecuService.getFiles(path);
        StringBuilder result = new StringBuilder("Found " + files.size() + " files to execute\n\n");
        for (String file : files) {
            result.append(file + "\n");
            ExecutionResult singleResult = this.aecuService.execute(file);
            this.aecuService.storeExecutionInHistory(history, singleResult);
            result.append(singleResult.toString());
            result.append("\n\n");
        }
        this.aecuService.finishHistoryEntry(history);
        return result.toString();
    }

    @Override
    public String executeWithHistory(String path) throws AecuException {
        HistoryEntry history = this.aecuService.createHistoryEntry();
        List files = this.aecuService.getFiles(path);
        StringBuilder result = new StringBuilder("Found " + files.size() + " files to execute\n\n");
        try (ResourceResolver resolver = this.serviceResourceResolver.getAdminResourceResolver();){
            Session session = (Session)resolver.adaptTo(Session.class);
            for (String file : files) {
                result.append(file + "\n");
                HookExecutionHistory executionHistory = new HookExecutionHistory(session, file);
                if (!file.endsWith("always.groovy") && executionHistory.hasBeenExecutedBefore()) {
                    result.append("Skipped due to history\n\n");
                    continue;
                }
                ExecutionResult singleResult = this.aecuService.execute(file);
                executionHistory.setExecuted();
                this.aecuService.storeExecutionInHistory(history, singleResult);
                result.append(singleResult.toString());
                result.append("\n\n");
            }
        }
        catch (LoginException e) {
            throw new AecuException(e.getMessage(), (Throwable)e);
        }
        this.aecuService.finishHistoryEntry(history);
        return result.toString();
    }

    @Override
    public String getHistory(int start, int count) throws AecuException {
        List entries = this.aecuService.getHistory(start, count);
        StringBuilder output = new StringBuilder();
        for (HistoryEntry entry : entries) {
            output.append(entry.toString() + "\n\n");
        }
        return output.toString();
    }
}

