/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.servlet;

import com.google.gson.Gson;
import de.valtech.aecu.api.groovy.console.bindings.AecuBinding;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.paths=/bin/public/valtech/aecu/ace_autocomplete", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class AceAutocompleteServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try (PrintWriter responseWriter = response.getWriter();){
            TreeSet<String> methodsSet = new TreeSet<String>();
            methodsSet.add("aecu");
            List<Method> methods = this.getPublicMethodsOfClass(AecuBinding.class);
            for (Method method : methods) {
                methodsSet.add(this.getCompletion(method));
                Class<?> extensionClass = method.getReturnType();
                List<Method> publicMethods = this.getPublicMethodsOfClass(extensionClass);
                publicMethods.stream().forEach(n -> methodsSet.add(this.getCompletion((Method)n)));
            }
            String responseString = new Gson().toJson((Object)methodsSet.toArray(new String[0]));
            responseWriter.write(responseString);
            response.setStatus(200);
        }
    }

    private String getCompletion(Method method) {
        return method.getName() + "(" + this.getCompletionForArguments(method) + ")";
    }

    private String getCompletionForArguments(Method method) {
        if (method.getParameterCount() == 0) {
            return "";
        }
        Parameter[] parameters = method.getParameters();
        ArrayList<String> parameterValues = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            if (parameter.isNamePresent()) {
                parameterValues.add(parameter.getName() + " " + parameter.getType().getSimpleName());
                continue;
            }
            parameterValues.add(parameter.getType().getSimpleName());
        }
        return String.join((CharSequence)", ", parameterValues);
    }

    protected List<Method> getPublicMethodsOfClass(Class clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> (m.getModifiers() & 1) != 0).collect(Collectors.toList());
    }
}

